/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonCategory
extends Button {
    private static final int ANIM_TIME = 5;
    final GuiBook parent;
    BookCategory category;
    final BookIcon icon;
    final String name;
    final int u;
    final int v;
    float timeHovered;

    public GuiButtonCategory(GuiBook parent, int x, int y, BookCategory category, Button.IPressable onPress) {
        this(parent, x, y, category.getIcon(), category.getName(), onPress);
        this.category = category;
    }

    public GuiButtonCategory(GuiBook parent, int x, int y, BookIcon icon, String name, Button.IPressable onPress) {
        super(parent.bookLeft + x, parent.bookTop + y, 20, 20, name, onPress);
        this.parent = parent;
        this.u = x;
        this.v = y;
        this.icon = icon;
        this.name = name;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.active) {
            boolean locked;
            this.timeHovered = this.isHovered() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.isHovered() ? partialTicks : -partialTicks)));
            float transparency = 0.5f - time / 5.0f * 0.5f;
            boolean bl = locked = this.category != null && this.category.isLocked();
            if (locked) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(this.parent.book, this.x + 2, this.y + 2);
            } else {
                this.icon.render(this.x + 2, this.y + 2);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)200.0f);
            GuiBook.drawFromTexture(this.parent.book, this.x, this.y, this.u, this.v, this.width, this.height);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.category != null && !this.category.isLocked()) {
                GuiBook.drawMarking(this.parent.book, this.x, this.y, 0, this.category.getReadState());
            }
            GlStateManager.popMatrix();
            if (this.isHovered) {
                this.parent.setTooltip(locked ? TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.locked", (Object[])new Object[0]) : this.name);
            }
        }
    }

    public void playDownSound(SoundHandler soundHandlerIn) {
        if (this.category != null && !this.category.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookCategory getCategory() {
        return this.category;
    }
}

