/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBookEntryList
extends GuiBook {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    BookTextRenderer text;
    List<Button> dependentButtons;
    List<BookEntry> allEntries;
    List<BookEntry> visibleEntries;
    TextFieldWidget searchField;

    public GuiBookEntryList(Book book, ITextComponent title) {
        super(book, title);
    }

    @Override
    public void init() {
        super.init();
        this.text = new BookTextRenderer(this, this.getDescriptionText(), 15, 40);
        this.visibleEntries = new ArrayList<BookEntry>();
        this.allEntries = new ArrayList<BookEntry>(this.getEntries());
        this.allEntries.removeIf(BookEntry::shouldHide);
        if (this.shouldSortEntryList()) {
            Collections.sort(this.allEntries);
        }
        this.searchField = new TextFieldWidget(this.font, 160, 170, 90, 12, "");
        this.searchField.func_146203_f(32);
        this.searchField.func_146185_a(false);
        this.searchField.func_146205_d(false);
        this.searchField.changeFocus(true);
        this.dependentButtons = new ArrayList<Button>();
        this.buildEntryButtons();
    }

    protected abstract String getDescriptionText();

    protected abstract Collection<BookEntry> getEntries();

    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return true;
    }

    protected boolean shouldDrawProgressBar() {
        return true;
    }

    protected boolean shouldSortEntryList() {
        return true;
    }

    protected void addSubcategoryButtons() {
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(mouseX, mouseY, partialTicks);
        if (this.page == 0) {
            this.drawCenteredStringNoShadow(this.getTitle().func_150254_d(), 73, 18, this.book.headerColor);
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.chapters", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookEntryList.drawSeparator(this.book, 15, 30);
            GuiBookEntryList.drawSeparator(this.book, 141, 30);
            this.text.render(mouseX, mouseY);
            if (this.shouldDrawProgressBar()) {
                this.drawProgressBar(this.book, mouseX, mouseY, this::doesEntryCountForProgress);
            }
        } else if (this.page % 2 == 1 && this.page == this.maxpages - 1 && this.dependentButtons.size() <= 13) {
            GuiBookEntryList.drawPageFiller(this.book);
        }
        if (!this.searchField.func_146179_b().isEmpty()) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookEntryList.drawFromTexture(this.book, this.searchField.x - 8, this.searchField.y, 140, 183, 99, 14);
            this.book.getFont().func_211126_b(this.searchField.func_146179_b(), (float)(this.searchField.x + 7), (float)(this.searchField.y + 1), 0);
        }
        if (this.visibleEntries.isEmpty()) {
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.no_results", (Object[])new Object[0]), 199, 80, 0x333333);
            GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.sad", (Object[])new Object[0]), 99, 47, 0x999999);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text.click(mouseX, mouseY, mouseButton) || this.searchField.mouseClicked(mouseX - (double)this.bookLeft, mouseY - (double)this.bookTop, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public boolean charTyped(char c, int i) {
        String currQuery = this.searchField.func_146179_b();
        if (this.searchField.charTyped(c, i)) {
            if (!this.searchField.func_146179_b().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.charTyped(c, i);
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        String currQuery = this.searchField.func_146179_b();
        if (key == 257) {
            if (this.visibleEntries.size() == 1) {
                this.displayLexiconGui(new GuiBookEntry(this.book, this.visibleEntries.get(0)), true);
                return true;
            }
        } else if (this.searchField.keyPressed(key, scanCode, modifiers)) {
            if (!this.searchField.func_146179_b().equals(currQuery)) {
                this.buildEntryButtons();
            }
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public void handleButtonCategory(Button button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    public void handleButtonEntry(Button button) {
        GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    void buildEntryButtons() {
        this.removeButtonsIn(this.dependentButtons);
        this.dependentButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.func_146179_b().toLowerCase();
        this.allEntries.stream().filter(e -> e.isFoundByQuery(query)).forEach(this.visibleEntries::add);
        this.maxpages = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxpages += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.page;
        }
        if (this.page == 0) {
            this.addEntryButtons(141, 38, 0, 11);
            this.addSubcategoryButtons();
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(15, 18, start, 13);
            this.addEntryButtons(141, 18, start + 13, 13);
        }
    }

    int getEntryCountStart() {
        if (this.page == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.page - 1);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.visibleEntries.get(start + i), this::handleButtonEntry);
            this.addButton(button);
            this.dependentButtons.add(button);
        }
    }
}

