/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBookEntryList;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class GuiBookCategory
extends GuiBookEntryList {
    BookCategory category;

    public GuiBookCategory(Book book, BookCategory category) {
        super(book, (ITextComponent)new StringTextComponent(category.getName()));
        this.category = category;
    }

    @Override
    protected String getDescriptionText() {
        return this.category.getDescription();
    }

    @Override
    protected Collection<BookEntry> getEntries() {
        return this.category.getEntries();
    }

    @Override
    protected void addSubcategoryButtons() {
        int i = 0;
        ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.contents.categories.values());
        Collections.sort(categories);
        for (BookCategory ocategory : categories) {
            if (ocategory.getParentCategory() != this.category || ocategory.shouldHide()) continue;
            int x = 25 + i % 4 * 24;
            int y = 174 - ((Boolean)PatchouliConfig.disableAdvancementLocking.get() != false ? 46 : 68);
            GuiButtonCategory button = new GuiButtonCategory(this, x, y, ocategory, this::handleButtonCategory);
            this.addButton(button);
            this.dependentButtons.add(button);
            ++i;
        }
    }

    @Override
    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return entry.getCategory() == this.category;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GuiBookCategory && ((GuiBookCategory)((Object)obj)).category == this.category && ((GuiBookCategory)((Object)obj)).page == this.page;
    }

    @Override
    public boolean canBeOpened() {
        return !this.category.isLocked() && !this.equals(Minecraft.func_71410_x().field_71462_r);
    }
}

