/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBack;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBook
extends Screen {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static int lastSound;
    public int bookLeft;
    public int bookTop;
    private float scaleFactor;
    private List<String> tooltip;
    private ItemStack tooltipStack;
    private Pair<BookEntry, Integer> targetPage;
    protected int page = 0;
    protected int maxpages = 0;
    public int ticksInBook;
    public int maxScale;
    boolean needsBookmarkUpdate = false;

    public GuiBook(Book book, ITextComponent title) {
        super(title);
        this.book = book;
    }

    public void init() {
        MainWindow res = this.minecraft.field_195558_d;
        double oldGuiScale = res.func_216521_a(this.minecraft.field_71474_y.field_74335_Z, this.minecraft.func_211821_e());
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        double newGuiScale = res.func_216521_a(persistentScale, this.minecraft.func_211821_e());
        if (persistentScale > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.func_198100_s();
            res.func_216525_a(newGuiScale);
            this.width = res.func_198107_o();
            this.height = res.func_198087_p();
            res.func_216525_a(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.bookLeft = this.width / 2 - 136;
        this.bookTop = this.height / 2 - 90;
        this.book.contents.currentGui = this;
        this.addButton(new GuiButtonBookBack(this, this.width / 2 - 9, this.bookTop + 180 - 5));
        this.addButton(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.addButton(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public final void render(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.pushMatrix();
        if (this.scaleFactor != 1.0f) {
            GlStateManager.scalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(mouseX, mouseY, partialTicks);
        GlStateManager.popMatrix();
    }

    final void drawScreenAfterScale(int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.renderBackground();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)this.bookLeft, (float)this.bookTop, (float)0.0f);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        GlStateManager.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new BookDrawScreenEvent(this, this.book.resourceLoc, mouseX, mouseY, partialTicks));
        this.drawTooltip(mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.removeButtonsIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (PersistentData.DataHolder.BookData.Bookmark bookmark : bookmarks) {
            this.addButton(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        y += y == 0 ? 0 : 2;
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.addButton(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.addButton(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 20, MultiblockVisualizationHandler.bookmark, true));
        }
    }

    public void removeButtonsIf(Predicate<IGuiEventListener> pred) {
        this.buttons.removeIf(pred);
        this.children.removeIf(pred);
    }

    public void removeButtonsIn(Collection<?> coll) {
        this.removeButtonsIf(coll::contains);
    }

    public <T extends Widget> T addButton(T p_addButton_1_) {
        return (T)super.addButton(p_addButton_1_);
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void tick() {
        if (!GuiBook.hasShiftDown()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = this.getTooltipFromItem(this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.contents.getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getLeft())) {
                tooltip.add(TextFormatting.GOLD + "(" + I18n.func_135052_a((String)"patchouli.gui.lexicon.shift_for_recipe", (Object[])new Object[0]) + ')');
                this.targetPage = provider;
            }
            GuiUtils.preItemToolTip((ItemStack)this.tooltipStack);
            FontRenderer font = this.tooltipStack.func_77973_b().getFontRenderer(this.tooltipStack);
            this.renderTooltip(tooltip, mouseX, mouseY, font == null ? this.font : font);
            GuiUtils.postItemToolTip();
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            ArrayList wrappedTooltip = new ArrayList();
            for (String s : this.tooltip) {
                Collections.addAll(wrappedTooltip, s.split("\n"));
            }
            GuiUtils.drawHoveringText(wrappedTooltip, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.font);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(Book book, int x, int y, int u, int v, int w, int h) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(book.bookResource);
        GuiBook.blit((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void handleButtonBack(Button button) {
        this.back(false);
    }

    public void handleButtonArrow(Button button) {
        this.changePage(((GuiButtonBookArrow)button).left, false);
    }

    public void handleButtonBookmark(Button button) {
        GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
        PersistentData.DataHolder.BookData.Bookmark bookmark = bookmarkButton.bookmark;
        if (bookmark == null || bookmark.getEntry(this.book) == null) {
            this.bookmarkThis();
        } else if (GuiBook.hasShiftDown() && !bookmarkButton.multiblock) {
            List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
            bookmarks.remove(bookmark);
            PersistentData.save();
            this.needsBookmarkUpdate = true;
        } else {
            this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.page), true);
        }
    }

    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClickedScaled(mouseX / (double)this.scaleFactor, mouseY / (double)this.scaleFactor, mouseButton);
    }

    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.hasShiftDown()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getLeft(), (Integer)this.targetPage.getRight()), true);
                GuiBook.playBookFlipSound(this.book);
                return true;
            }
            case 1: {
                this.back(true);
                return true;
            }
            case 3: {
                this.changePage(true, true);
                return true;
            }
            case 4: {
                this.changePage(false, true);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            this.back(true);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.changePage(false, true);
        } else if (scroll > 0.0) {
            this.changePage(true, true);
        }
        return true;
    }

    void back(boolean sfx) {
        if (!this.book.contents.guiStack.isEmpty()) {
            if (GuiBook.hasShiftDown()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.contents.guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.contents.guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            this.page = left ? --this.page : ++this.page;
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.page > 0 : this.page + 1 < this.maxpages;
    }

    public boolean canSeeBackButton() {
        return !this.book.contents.guiStack.isEmpty();
    }

    public void setTooltip(String ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<String> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(ItemStack stack) {
        this.setTooltip(new String[0]);
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = absMx - (double)((float)this.bookLeft * this.scaleFactor);
        double my = absMy - (double)((float)this.bookTop * this.scaleFactor);
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public void drawProgressBar(Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || ((Boolean)PatchouliConfig.disableAdvancementLocking.get()).booleanValue()) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.contents.entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        GuiBook.fill((int)barLeft, (int)barTop, (int)(barLeft + barWidth), (int)(barTop + barHeight), (int)book.headerColor);
        this.drawGradient(barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        this.font.func_211126_b(I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_meter", (Object[])new Object[0]), (float)barLeft, (float)(barTop - 9), book.headerColor);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            String progressStr = I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip", (Object[])new Object[]{unlockedEntries, totalEntries});
            tooltip.add(progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip.secret1", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip.secret", (Object[])new Object[]{unlockedSecretEntries}));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip.info", (Object[])new Object[0]));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        this.fillGradient(x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(String s, int x, int y, int color) {
        this.font.func_211126_b(s, (float)(x - this.font.func_78256_a(s) / 2), (float)y, color);
    }

    private int getMaxAllowedScale() {
        return this.minecraft.field_195558_d.func_216521_a(0, this.minecraft.func_211821_e());
    }

    public int getPage() {
        return this.page;
    }

    public static void drawSeparator(Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiBook.drawFromTexture(book, rx, y, 140, 180, w, h);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(Book book, int x, int y) {
        GuiBook.drawFromTexture(book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(book, x, y, state.u, 197, 8, 8);
        GlStateManager.enableAlphaTest();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(Book book) {
        GuiBook.drawPageFiller(book, 141, 18);
    }

    public static void drawPageFiller(Book book, int x, int y) {
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(book.fillerResource);
        GuiBook.blit((int)(x + 58 - 64), (int)(y + 78 - 74), (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6) {
            SoundEvent sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.book_flip);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(String address) {
        Util.func_110647_a().func_195640_a(address);
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.contents.openLexiconGui(gui, push);
    }
}

