/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.page.PageCrafting;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.page.PageImage;
import vazkii.patchouli.client.book.page.PageLink;
import vazkii.patchouli.client.book.page.PageMultiblock;
import vazkii.patchouli.client.book.page.PageQuest;
import vazkii.patchouli.client.book.page.PageRelations;
import vazkii.patchouli.client.book.page.PageSmelting;
import vazkii.patchouli.client.book.page.PageSpotlight;
import vazkii.patchouli.client.book.page.PageTemplate;
import vazkii.patchouli.client.book.page.PageText;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.client.handler.UnicodeFontHandler;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.util.SerializationUtil;

public class ClientBookRegistry {
    public final Map<String, Class<? extends BookPage>> pageTypes = new HashMap<String, Class<? extends BookPage>>();
    private boolean firstLoad = true;
    public final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(BookPage.class, (Object)new LexiconPageAdapter()).registerTypeHierarchyAdapter(TemplateComponent.class, (Object)new TemplateComponentAdapter()).create();
    public String currentLang;
    public static final ClientBookRegistry INSTANCE = new ClientBookRegistry();

    private ClientBookRegistry() {
    }

    public void init() {
        this.addPageTypes();
    }

    private void addPageTypes() {
        this.pageTypes.put("text", PageText.class);
        this.pageTypes.put("crafting", PageCrafting.class);
        this.pageTypes.put("smelting", PageSmelting.class);
        this.pageTypes.put("image", PageImage.class);
        this.pageTypes.put("spotlight", PageSpotlight.class);
        this.pageTypes.put("empty", PageEmpty.class);
        this.pageTypes.put("multiblock", PageMultiblock.class);
        this.pageTypes.put("link", PageLink.class);
        this.pageTypes.put("relations", PageRelations.class);
        this.pageTypes.put("entity", PageEntity.class);
        this.pageTypes.put("quest", PageQuest.class);
    }

    public void reload() {
        this.currentLang = Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode();
        if (this.firstLoad) {
            UnicodeFontHandler.getUnicodeFont();
        }
        this.firstLoad = false;
        BookRegistry.INSTANCE.reloadContents();
    }

    public void reloadLocks(boolean reset) {
        BookRegistry.INSTANCE.books.values().forEach(b -> b.reloadLocks(reset));
    }

    public void displayBookGui(String bookStr) {
        this.currentLang = Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode();
        ResourceLocation res = new ResourceLocation(bookStr);
        Book book = BookRegistry.INSTANCE.books.get(res);
        if (book != null) {
            if (!book.contents.getCurrentGui().canBeOpened()) {
                book.contents.currentGui = null;
                book.contents.guiStack.clear();
            }
            book.contents.openLexiconGui(book.contents.getCurrentGui(), false);
        }
    }

    public static class TemplateComponentAdapter
    implements JsonDeserializer<TemplateComponent> {
        public TemplateComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)obj.get("type");
            String type = prim.getAsString();
            Class<? extends TemplateComponent> clazz = BookTemplate.componentTypes.get(type);
            if (clazz == null) {
                return null;
            }
            TemplateComponent component = (TemplateComponent)SerializationUtil.RAW_GSON.fromJson(json, clazz);
            component.sourceObject = obj;
            return component;
        }
    }

    public static class LexiconPageAdapter
    implements JsonDeserializer<BookPage> {
        public BookPage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)obj.get("type");
            String type = prim.getAsString();
            Class<? extends BookPage> clazz = ClientBookRegistry.INSTANCE.pageTypes.get(type);
            if (clazz == null) {
                clazz = PageTemplate.class;
            }
            BookPage page = (BookPage)SerializationUtil.RAW_GSON.fromJson(json, clazz);
            page.sourceObject = obj;
            return page;
        }
    }
}

