/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.SearchMode;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public class IngredientListElementRenderer<T> {
    private static final int BLACKLIST_COLOR = -65536;
    private static final Rectangle2d DEFAULT_AREA = new Rectangle2d(0, 0, 16, 16);
    protected final IIngredientListElement<T> element;
    protected final IIngredientRenderer<T> ingredientRenderer;
    protected final IIngredientHelper<T> ingredientHelper;
    protected Rectangle2d area = DEFAULT_AREA;
    protected int padding;

    public IngredientListElementRenderer(IIngredientListElement<T> element) {
        this.element = element;
        T ingredient = element.getIngredient();
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientType<T> ingredientType = ingredientManager.getIngredientType(ingredient);
        this.ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
    }

    public void setArea(Rectangle2d area) {
        this.area = area;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public IIngredientListElement<T> getElement() {
        return this.element;
    }

    public Rectangle2d getArea() {
        return this.area;
    }

    public void renderSlow(IEditModeConfig editModeConfig, IWorldConfig worldConfig) {
        if (worldConfig.isEditModeEnabled()) {
            this.renderEditMode(this.area, this.padding, editModeConfig);
        }
        try {
            T ingredient = this.element.getIngredient();
            this.ingredientRenderer.render(this.area.func_199318_a() + this.padding, this.area.func_199319_b() + this.padding, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    public void drawHighlight() {
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiUtils.drawGradientRect((int)0, (int)this.area.func_199318_a(), (int)this.area.func_199319_b(), (int)(this.area.func_199318_a() + this.area.func_199316_c()), (int)(this.area.func_199319_b() + this.area.func_199317_d()), (int)-2130706433, (int)-2130706433);
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.enableDepthTest();
    }

    public void drawTooltip(int mouseX, int mouseY, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig) {
        T ingredient = this.element.getIngredient();
        List<String> tooltip = this.getTooltip(ingredientFilterConfig, worldConfig);
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, ingredient);
        TooltipRenderer.drawHoveringText(ingredient, tooltip, mouseX, mouseY, fontRenderer);
    }

    protected void renderEditMode(Rectangle2d area, int padding, IEditModeConfig editModeConfig) {
        T ingredient = this.element.getIngredient();
        if (editModeConfig.isIngredientOnConfigBlacklist(ingredient, this.ingredientHelper)) {
            Screen.fill((int)(area.func_199318_a() + padding), (int)(area.func_199319_b() + padding), (int)(area.func_199318_a() + 16 + padding), (int)(area.func_199319_b() + 16 + padding), (int)-65536);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private List<String> getTooltip(IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig) {
        T ingredient = this.element.getIngredient();
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        List<String> tooltip = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, this.ingredientRenderer, this.ingredientHelper, modIdHelper);
        Minecraft minecraft = Minecraft.func_71410_x();
        int maxWidth = 150;
        for (String tooltipLine : tooltip) {
            int width = minecraft.field_71466_p.func_78256_a(tooltipLine);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(minecraft, tooltip, maxWidth);
        }
        if (worldConfig.isEditModeEnabled()) {
            IngredientListElementRenderer.addEditModeInfoToTooltip(minecraft, tooltip, maxWidth);
        }
        return tooltip;
    }

    private void addColorSearchInfoToTooltip(Minecraft minecraft, List<String> tooltip, int maxWidth) {
        T ingredient;
        Iterable<Integer> colors;
        ColorNamer colorNamer = Internal.getColorNamer();
        Collection<String> colorNames = colorNamer.getColorNames(colors = this.ingredientHelper.getColors(ingredient = this.element.getIngredient()), false);
        if (!colorNames.isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            String colorNamesLocalizedString = TextFormatting.GRAY + Translator.translateToLocalFormatted("jei.tooltip.item.colors", colorNamesString);
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(colorNamesLocalizedString, maxWidth));
        }
    }

    private static void addEditModeInfoToTooltip(Minecraft minecraft, List<String> tooltip, int maxWidth) {
        tooltip.add("");
        tooltip.add(TextFormatting.DARK_GREEN + Translator.translateToLocal("gui.jei.editMode.description"));
        String controlKeyLocalization = Translator.translateToLocal(Minecraft.field_142025_a ? "key.jei.ctrl.mac" : "key.jei.ctrl");
        String hideMessage = TextFormatting.GRAY + Translator.translateToLocalFormatted("gui.jei.editMode.description.hide", controlKeyLocalization);
        tooltip.addAll(minecraft.field_71466_p.func_78271_c(hideMessage, maxWidth));
        String hideWildMessage = TextFormatting.GRAY + Translator.translateToLocalFormatted("gui.jei.editMode.description.hide.wild", controlKeyLocalization);
        tooltip.addAll(minecraft.field_71466_p.func_78271_c(hideWildMessage, maxWidth));
    }
}

