/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import mezz.jei.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendableRecipeCategoryHelper<T, W extends IRecipeCategoryExtension> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<RecipeHandler<? extends T, ? extends W>> recipeHandlers = new ArrayList<RecipeHandler<? extends T, ? extends W>>();
    private final Set<Class<? extends T>> handledClasses = new HashSet<Class<? extends T>>();
    private final Map<T, W> cache = new IdentityHashMap<T, W>();
    private final Class<? extends T> expectedRecipeClass;

    public ExtendableRecipeCategoryHelper(Class<? extends T> expectedRecipeClass) {
        this.expectedRecipeClass = expectedRecipeClass;
    }

    public <R extends T> void addRecipeExtensionFactory(Class<? extends R> recipeClass, Function<R, ? extends W> recipeExtensionFactory) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        if (!this.expectedRecipeClass.isAssignableFrom(recipeClass)) {
            throw new IllegalArgumentException("Recipe handlers must handle a specific class. Needed: " + this.expectedRecipeClass + " Got: " + recipeClass);
        }
        ErrorUtil.checkNotNull(recipeExtensionFactory, "recipeExtensionFactory");
        if (this.handledClasses.contains(recipeClass)) {
            throw new IllegalArgumentException("A Recipe Extension Factory has already been registered for '" + recipeClass.getName());
        }
        this.handledClasses.add(recipeClass);
        this.recipeHandlers.add(new RecipeHandler<R, W>(recipeClass, recipeExtensionFactory));
    }

    public <R extends T> W getRecipeExtension(R recipe) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        return (W)this.cache.computeIfAbsent(recipe, this::getRecipeExtensionUncached);
    }

    private <R extends T> W getRecipeExtensionUncached(R recipe) {
        Class<?> recipeClass = recipe.getClass();
        ArrayList<RecipeHandler<R, W>> assignableHandlers = new ArrayList<RecipeHandler<R, W>>();
        for (RecipeHandler<R, W> recipeHandler : this.recipeHandlers) {
            Class<T> clazz = recipeHandler.getRecipeClass();
            if (!clazz.isAssignableFrom(recipeClass)) continue;
            RecipeHandler<R, W> assignableRecipeHandler = recipeHandler;
            if (clazz.equals(recipeClass)) {
                return assignableRecipeHandler.apply(recipe);
            }
            assignableHandlers.removeIf(handler -> handler.getRecipeClass().isAssignableFrom(handlerRecipeClass));
            if (!assignableHandlers.stream().noneMatch(handler -> handlerRecipeClass.isAssignableFrom(handler.getRecipeClass()))) continue;
            assignableHandlers.add(assignableRecipeHandler);
        }
        if (assignableHandlers.isEmpty()) {
            String recipeName = ErrorUtil.getNameForRecipe(recipe);
            throw new RuntimeException("Failed to create recipe wrapper for recipe: " + recipeName);
        }
        if (assignableHandlers.size() == 1) {
            RecipeHandler recipeHandler3 = (RecipeHandler)assignableHandlers.get(0);
            return recipeHandler3.apply(recipe);
        }
        Class<?> superClass = recipeClass;
        while (!Object.class.equals(superClass)) {
            superClass = superClass.getSuperclass();
            for (RecipeHandler recipeHandler : assignableHandlers) {
                if (!recipeHandler.getRecipeClass().equals(superClass)) continue;
                return recipeHandler.apply(recipe);
            }
        }
        List list = assignableHandlers.stream().map(RecipeHandler::getRecipeClass).collect(Collectors.toList());
        LOGGER.warn("Found multiple matching recipe handlers for {}: {}", recipeClass, list);
        RecipeHandler recipeHandler = (RecipeHandler)assignableHandlers.get(0);
        return recipeHandler.apply(recipe);
    }

    public static class RecipeHandler<T, W extends IRecipeCategoryExtension> {
        private final Class<? extends T> recipeClass;
        private final Function<T, W> factory;

        public RecipeHandler(Class<? extends T> recipeClass, Function<T, W> factory) {
            this.recipeClass = recipeClass;
            this.factory = factory;
        }

        public Class<? extends T> getRecipeClass() {
            return this.recipeClass;
        }

        public W apply(T t) {
            return (W)((IRecipeCategoryExtension)this.factory.apply(t));
        }
    }
}

