/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.HoverChecker;
import mezz.jei.gui.elements.DrawableNineSliceTexture;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.Rectangle2d;

public class GuiTextFieldFilter
extends TextFieldWidget {
    private static final int MAX_HISTORY = 100;
    private static final int maxSearchLength = 128;
    private static final List<String> history = new LinkedList<String>();
    private final HoverChecker hoverChecker;
    private final IIngredientGridSource ingredientSource;
    private final IWorldConfig worldConfig;
    private boolean previousKeyboardRepeatEnabled;
    private final DrawableNineSliceTexture background;
    private boolean isDrawing = false;

    public GuiTextFieldFilter(IIngredientGridSource ingredientSource, IWorldConfig worldConfig) {
        super(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0, "");
        this.worldConfig = worldConfig;
        this.func_146203_f(128);
        this.hoverChecker = new HoverChecker();
        this.ingredientSource = ingredientSource;
        this.background = Internal.getTextures().getSearchBackground();
    }

    public void updateBounds(Rectangle2d area) {
        this.x = area.func_199318_a();
        this.y = area.func_199319_b();
        this.width = area.func_199316_c();
        this.height = area.func_199317_d();
        this.hoverChecker.updateBounds(area.func_199319_b(), area.func_199319_b() + area.func_199317_d(), area.func_199318_a(), area.func_199318_a() + area.func_199316_c());
        this.func_146199_i(this.func_146198_h());
    }

    public void update() {
        List<IIngredientListElement<?>> ingredientList;
        String filterText = this.worldConfig.getFilterText();
        if (!filterText.equals(this.func_146179_b())) {
            this.func_146180_a(filterText);
        }
        if ((ingredientList = this.ingredientSource.getIngredientList(filterText)).size() == 0) {
            this.func_146193_g(-65536);
        } else {
            this.func_146193_g(-1);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean handled = super.keyPressed(keyCode, scanCode, modifiers);
        if (!handled && !history.isEmpty()) {
            if (keyCode == 265) {
                String currentText = this.func_146179_b();
                int historyIndex = history.indexOf(currentText);
                if (historyIndex < 0) {
                    historyIndex = this.saveHistory() ? history.size() - 1 : history.size();
                }
                if (historyIndex > 0) {
                    String historyString = history.get(historyIndex - 1);
                    this.func_146180_a(historyString);
                    handled = true;
                }
            } else if (keyCode == 264) {
                String currentText = this.func_146179_b();
                int historyIndex = history.indexOf(currentText);
                if (historyIndex >= 0) {
                    String historyString = historyIndex + 1 < history.size() ? history.get(historyIndex + 1) : "";
                    this.func_146180_a(historyString);
                    handled = true;
                }
            } else if (KeyBindings.isEnterKey(keyCode)) {
                this.saveHistory();
            }
        }
        return handled;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.func_146180_a("");
            return this.worldConfig.setFilterText("");
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        return false;
    }

    public void setFocused(boolean keyboardFocus) {
        boolean previousFocus = this.isFocused();
        super.setFocused(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (keyboardFocus) {
                this.previousKeyboardRepeatEnabled = minecraft.field_195559_v.field_197973_b;
                minecraft.field_195559_v.func_197967_a(true);
            } else {
                minecraft.field_195559_v.func_197967_a(this.previousKeyboardRepeatEnabled);
            }
            this.saveHistory();
        }
    }

    private boolean saveHistory() {
        String text = this.func_146179_b();
        if (text.length() > 0) {
            history.remove(text);
            history.add(text);
            if (history.size() > 100) {
                history.remove(0);
            }
            return true;
        }
        return false;
    }

    protected boolean func_146181_i() {
        if (this.isDrawing) {
            return false;
        }
        return super.func_146181_i();
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.isDrawing = true;
        if (this.func_146176_q()) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.background.draw(this.x, this.y, this.width, this.height);
        }
        super.renderButton(mouseX, mouseY, partialTicks);
        this.isDrawing = false;
    }
}

