/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.lens.Lens;

public class LensFirework
extends Lens {
    @Override
    public boolean collideBurst(IManaBurst burst, ThrowableEntity entity, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        if (!entity.field_70170_p.field_72995_K && !burst.isFake()) {
            BlockPos coords = burst.getBurstSourceBlockPos();
            if (pos.func_216346_c() == RayTraceResult.Type.BLOCK && !isManaBlock && !((BlockRayTraceResult)pos).func_216350_a().equals((Object)coords)) {
                ItemStack fireworkStack = this.generateFirework(burst.getColor());
                FireworkRocketEntity rocket = new FireworkRocketEntity(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, fireworkStack);
                entity.field_70170_p.func_217376_c((Entity)rocket);
            }
        } else {
            dead = false;
        }
        return dead;
    }

    private ItemStack generateFirework(int color) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
        CompoundNBT explosion = new CompoundNBT();
        explosion.func_74783_a("Colors", new int[]{color});
        int type = 1;
        double rand = Math.random();
        if (rand > 0.25) {
            type = rand > 0.9 ? 2 : 0;
        }
        explosion.func_74768_a("Type", type);
        if (Math.random() < 0.05) {
            if (Math.random() < 0.5) {
                explosion.func_74757_a("Flicker", true);
            } else {
                explosion.func_74757_a("Trail", true);
            }
        }
        ItemNBTHelper.setCompound(stack, "Explosion", explosion);
        CompoundNBT fireworks = new CompoundNBT();
        fireworks.func_74768_a("Flight", (int)(Math.random() * 3.0 + 2.0));
        ListNBT explosions = new ListNBT();
        explosions.add((Object)explosion);
        fireworks.func_218657_a("Explosions", (INBT)explosions);
        ItemNBTHelper.setCompound(stack, "Fireworks", fireworks);
        return stack;
    }
}

