/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemWaterRing
extends ItemBauble
implements IManaUsingItem {
    private static final int COST = 3;

    public ItemWaterRing(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        if (living.func_203005_aq()) {
            ItemStack result = EquipmentHandler.findOrEmpty(ModItems.waterRing, living);
            if (result != stack) {
                return;
            }
            if (!living.field_70170_p.field_72995_K) {
                if (living instanceof PlayerEntity && !ManaItemHandler.requestManaExact(stack, (PlayerEntity)living, 3, true)) {
                    this.onUnequipped(stack, living);
                } else {
                    ItemWaterRing.addEffect(living, Effects.field_205136_C);
                    ItemWaterRing.addEffect(living, Effects.field_206827_D);
                }
            }
        } else {
            this.onUnequipped(stack, living);
        }
    }

    private static void addEffect(LivingEntity living, Effect effect) {
        EffectInstance inst = living.func_70660_b(effect);
        if (inst == null || inst.func_76458_c() == 0 && inst.func_76459_b() == 1) {
            EffectInstance neweffect = new EffectInstance(effect, 100, 0, true, true);
            living.func_195064_c(neweffect);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

