/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemTinyPlanet
extends ItemBauble {
    public static final String TAG_ORBIT = "orbit";

    public ItemTinyPlanet(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        ItemTinyPlanet.applyEffect(player.field_70170_p, x, y, z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.translatef((float)0.0f, (float)-1.5f, (float)0.5f);
        Minecraft.func_71410_x().func_175602_ab().func_175016_a(ModBlocks.tinyPlanet.func_176223_P(), 1.0f);
    }

    public static void applyEffect(World world, double x, double y, double z) {
        int range = 8;
        List entities = world.func_175647_a(ThrowableEntity.class, new AxisAlignedBB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range), (Predicate)Predicates.instanceOf(IManaBurst.class));
        for (ThrowableEntity entity : entities) {
            IManaBurst burst = (IManaBurst)entity;
            ItemStack lens = burst.getSourceLens();
            if (lens != null && lens.func_77973_b() instanceof ITinyPlanetExcempt && !((ITinyPlanetExcempt)lens.func_77973_b()).shouldPull(lens)) continue;
            int orbitTime = ItemTinyPlanet.getEntityOrbitTime((Entity)entity);
            if (orbitTime == 0) {
                burst.setMinManaLoss(burst.getMinManaLoss() * 3);
            }
            float radius = Math.min(7.5f, (float)(Math.max(40, orbitTime) - 40) / 40.0f + 1.5f);
            int angle = orbitTime % 360;
            float xTarget = (float)(x + Math.cos((double)(angle * 10) * Math.PI / 180.0) * (double)radius);
            float yTarget = (float)y;
            float zTarget = (float)(z + Math.sin((double)(angle * 10) * Math.PI / 180.0) * (double)radius);
            Vector3 targetVec = new Vector3(xTarget, yTarget, zTarget);
            Vector3 currentVec = new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vector3 moveVector = targetVec.subtract(currentVec);
            burst.setBurstMotion(moveVector.x, moveVector.y, moveVector.z);
            ItemTinyPlanet.incrementOrbitTime((Entity)entity);
        }
    }

    public static int getEntityOrbitTime(Entity entity) {
        CompoundNBT cmp = entity.getPersistentData();
        if (cmp.func_74764_b(TAG_ORBIT)) {
            return cmp.func_74762_e(TAG_ORBIT);
        }
        return 0;
    }

    public static void incrementOrbitTime(Entity entity) {
        CompoundNBT cmp = entity.getPersistentData();
        int time = ItemTinyPlanet.getEntityOrbitTime(entity);
        cmp.func_74768_a(TAG_ORBIT, time + 1);
    }
}

