/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.StringObfuscator;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemFlightTiara
extends ItemBauble
implements IManaUsingItem {
    private static final ResourceLocation textureHud = new ResourceLocation("botania:textures/gui/hud_icons.png");
    private static final ResourceLocation textureHalo = new ResourceLocation("botania:textures/misc/halo.png");
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_FLYING = "flying";
    private static final String TAG_GLIDING = "gliding";
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_INFINITE_FLIGHT = "infiniteFlight";
    private static final String TAG_DASH_COOLDOWN = "dashCooldown";
    private static final String TAG_IS_SPRINTING = "isSprinting";
    private static final String TAG_BOOST_PENDING = "boostPending";
    private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList());
    private static final int COST = 35;
    private static final int COST_OVERKILL = 105;
    private static final int MAX_FLY_TIME = 1200;
    private static final int SUBTYPES = 8;
    public static final int WING_TYPES = 9;
    private static final String SUPER_AWESOME_HASH = "4D0F274C5E3001C95640B5E88A821422C8B1E132264492C043A3D746B705C025";

    public ItemFlightTiara(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::updatePlayerFlyStatus);
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedOut);
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemNBTHelper.setInt(stack, TAG_VARIANT, i);
                list.add((Object)stack);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        super.addHiddenTooltip(stack, world, stacks, flags);
        stacks.add((ITextComponent)new TranslationTextComponent("botania.wings" + ItemFlightTiara.getVariant(stack), new Object[0]));
    }

    private void updatePlayerFlyStatus(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack tiara = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (LivingEntity)player);
            int left = ItemNBTHelper.getInt(tiara, TAG_TIME_LEFT, 1200);
            if (playersWithFlight.contains(ItemFlightTiara.playerStr(player))) {
                if (this.shouldPlayerHaveFlight(player)) {
                    player.field_71075_bZ.field_75101_c = true;
                    if (player.field_71075_bZ.field_75100_b) {
                        if (!player.field_70170_p.field_72995_K) {
                            ManaItemHandler.requestManaExact(tiara, player, this.getCost(tiara, left), true);
                        } else if (Math.abs(player.func_213322_ci().func_82615_a()) > 0.1 || Math.abs(player.func_213322_ci().func_82616_c()) > 0.1) {
                            double x = event.getEntityLiving().field_70165_t - 0.5;
                            double y = event.getEntityLiving().field_70163_u - 0.5;
                            double z = event.getEntityLiving().field_70161_v - 0.5;
                            player.func_146103_bH().getName();
                            float r = 1.0f;
                            float g = 1.0f;
                            float b = 1.0f;
                            int variant = ItemFlightTiara.getVariant(tiara);
                            switch (variant) {
                                case 2: {
                                    r = 0.1f;
                                    g = 0.1f;
                                    b = 0.1f;
                                    break;
                                }
                                case 3: {
                                    r = 0.0f;
                                    g = 0.6f;
                                    break;
                                }
                                case 4: {
                                    g = 0.3f;
                                    b = 0.3f;
                                    break;
                                }
                                case 5: {
                                    r = 0.6f;
                                    g = 0.0f;
                                    b = 0.6f;
                                    break;
                                }
                                case 6: {
                                    r = 0.4f;
                                    g = 0.0f;
                                    b = 0.0f;
                                    break;
                                }
                                case 7: {
                                    r = 0.2f;
                                    g = 0.6f;
                                    b = 0.2f;
                                    break;
                                }
                                case 8: {
                                    r = 0.85f;
                                    g = 0.85f;
                                    b = 0.0f;
                                    break;
                                }
                                case 9: {
                                    r = 0.0f;
                                    b = 0.0f;
                                }
                            }
                            for (int i = 0; i < 2; ++i) {
                                SparkleParticleData data = SparkleParticleData.sparkle(2.0f * (float)Math.random(), r, g, b, 20);
                                player.field_70170_p.func_195594_a((IParticleData)data, x + Math.random() * (double)event.getEntityLiving().func_213311_cf(), y + Math.random() * 0.4, z + Math.random() * (double)event.getEntityLiving().func_213311_cf(), 0.0, 0.0, 0.0);
                            }
                        }
                    }
                } else {
                    if (!player.func_175149_v() && !player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75102_a = false;
                    }
                    playersWithFlight.remove(ItemFlightTiara.playerStr(player));
                }
            } else if (this.shouldPlayerHaveFlight(player)) {
                playersWithFlight.add(ItemFlightTiara.playerStr(player));
                player.field_71075_bZ.field_75101_c = true;
            }
        }
    }

    private void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.getPlayer().func_146103_bH().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    private static String playerStr(PlayerEntity player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }

    private boolean shouldPlayerHaveFlight(PlayerEntity player) {
        ItemStack armor = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (LivingEntity)player);
        if (!armor.func_190926_b()) {
            int left = ItemNBTHelper.getInt(armor, TAG_TIME_LEFT, 1200);
            boolean flying = ItemNBTHelper.getBoolean(armor, TAG_FLYING, false);
            return (left > (flying ? 0 : 120) || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.flugelEye))) && ManaItemHandler.requestManaExact(armor, player, this.getCost(armor, left), false);
        }
        return false;
    }

    public int getCost(ItemStack stack, int timeLeft) {
        return timeLeft <= 0 ? 105 : 35;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onEquipped(ItemStack stack, LivingEntity living) {
        super.onEquipped(stack, living);
        int variant = ItemFlightTiara.getVariant(stack);
        if (variant != 9 && StringObfuscator.matchesHash(stack.func_200301_q().getString(), SUPER_AWESOME_HASH)) {
            ItemNBTHelper.setInt(stack, TAG_VARIANT, 9);
            stack.func_135074_t();
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        if (player instanceof PlayerEntity) {
            int time;
            PlayerEntity p = (PlayerEntity)player;
            boolean flying = p.field_71075_bZ.field_75100_b;
            boolean wasSprting = ItemNBTHelper.getBoolean(stack, TAG_IS_SPRINTING, false);
            boolean isSprinting = p.func_70051_ag();
            if (isSprinting != wasSprting) {
                ItemNBTHelper.setBoolean(stack, TAG_IS_SPRINTING, isSprinting);
            }
            int newTime = time = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, 1200);
            Vector3 look = new Vector3(p.func_70040_Z()).multiply(1.0, 0.0, 1.0).normalize();
            if (flying) {
                if (!(time <= 0 || p.func_175149_v() || p.func_184812_l_() || ItemNBTHelper.getBoolean(stack, TAG_INFINITE_FLIGHT, false))) {
                    --newTime;
                }
                int maxCd = 80;
                int cooldown = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
                if (!wasSprting && isSprinting && cooldown == 0) {
                    p.func_213317_d(p.func_213322_ci().func_72441_c(look.x, 0.0, look.z));
                    p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, ModSounds.dash, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, 80);
                    ItemNBTHelper.setBoolean(stack, TAG_BOOST_PENDING, true);
                } else if (cooldown > 0) {
                    if (ItemNBTHelper.getBoolean(stack, TAG_BOOST_PENDING, false)) {
                        player.func_213309_a(5.0f, new Vec3d(0.0, 0.0, 1.0));
                        ItemNBTHelper.removeEntry(stack, TAG_BOOST_PENDING);
                    }
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, cooldown - 2);
                }
            } else {
                boolean doGlide;
                boolean wasGliding = ItemNBTHelper.getBoolean(stack, TAG_GLIDING, false);
                boolean bl = doGlide = player.func_70093_af() && !player.field_70122_E && (player.func_213322_ci().func_82617_b() < (double)-0.7f || wasGliding);
                if (time < 1200 && player.field_70173_aa % (doGlide ? 6 : 2) == 0) {
                    ++newTime;
                }
                if (doGlide) {
                    float mul = 0.6f;
                    player.func_213293_j(look.x * (double)mul, Math.max((double)-0.15f, player.func_213322_ci().func_82617_b()), look.z * (double)mul);
                    player.field_70143_R = 2.0f;
                }
                ItemNBTHelper.setBoolean(stack, TAG_GLIDING, doGlide);
            }
            ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
            if (newTime != time) {
                ItemNBTHelper.setInt(stack, TAG_TIME_LEFT, newTime);
            }
        }
    }

    @Override
    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return super.hasRender(stack, living) && living instanceof PlayerEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        int meta = ItemFlightTiara.getVariant(stack);
        if (meta > 0 && meta <= MiscellaneousIcons.INSTANCE.tiaraWingIcons.length) {
            TextureAtlasSprite icon = MiscellaneousIcons.INSTANCE.tiaraWingIcons[meta - 1];
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            boolean flying = ((PlayerEntity)player).field_71075_bZ.field_75100_b;
            float rz = 120.0f;
            float rx = 20.0f + (float)((Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)(flying ? 0.4f : 0.2f)) + 0.5) * (double)(flying ? 30.0f : 5.0f));
            float ry = 0.0f;
            float h = 0.2f;
            float i = 0.15f;
            float s = 1.0f;
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int light = 0xF000F0;
            int lightmapX = light % 65536;
            int lightmapY = light / 65536;
            float lbx = GLX.lastBrightnessX;
            float lby = GLX.lastBrightnessY;
            switch (meta) {
                case 1: {
                    h = 0.4f;
                    break;
                }
                case 2: {
                    s = 1.3f;
                    break;
                }
                case 3: {
                    h = -0.1f;
                    rz = 0.0f;
                    rx = 0.0f;
                    i = 0.3f;
                    break;
                }
                case 4: {
                    rz = 180.0f;
                    h = 0.5f;
                    rx = 20.0f;
                    ry = -((float)((Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)(flying ? 0.4f : 0.2f)) + (double)0.6f) * (double)(flying ? 30.0f : 5.0f)));
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
                    break;
                }
                case 5: {
                    h = 0.8f;
                    rz = 180.0f;
                    ry = -rx;
                    rx = 0.0f;
                    s = 2.0f;
                    break;
                }
                case 6: {
                    rz = 150.0f;
                    break;
                }
                case 7: {
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
                    h = -0.1f;
                    rz = 0.0f;
                    ry = -rx;
                    rx = 0.0f;
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + (float)Math.cos((double)((float)player.field_70173_aa + partialTicks) * (double)0.3f) * 0.2f));
                    break;
                }
                case 8: {
                    h = 0.1f;
                    break;
                }
                case 9: {
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
                    rz = 180.0f;
                    rx = 0.0f;
                    h = 1.1f;
                    ry = -((float)((Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)0.2f) + (double)0.6f) * (double)(flying ? 12.0f : 5.0f)));
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + (flying ? (float)Math.cos((double)((float)player.field_70173_aa + partialTicks) * (double)0.3f) * 0.25f + 0.25f : 0.0f)));
                }
            }
            float mul = 1.6f;
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            float sr = 1.0f / (s *= mul);
            AccessoryRenderHelper.rotateIfSneaking(player);
            GlStateManager.translatef((float)0.0f, (float)h, (float)i);
            GlStateManager.rotatef((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)s, (float)s, (float)s);
            IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.03125f);
            GlStateManager.scalef((float)sr, (float)sr, (float)sr);
            GlStateManager.rotatef((float)(-ry), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)(-rx), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(-rz), (float)0.0f, (float)0.0f, (float)1.0f);
            if (meta != 2) {
                GlStateManager.scalef((float)-1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.rotatef((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.rotatef((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.scalef((float)s, (float)s, (float)s);
                IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.03125f);
                GlStateManager.scalef((float)sr, (float)sr, (float)sr);
                GlStateManager.rotatef((float)(-ry), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)(-rx), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)(-rz), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lbx, (float)lby);
            if (meta == 1) {
                ItemFlightTiara.renderHalo(player, partialTicks);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHalo(LivingEntity player, float partialTicks) {
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.shadeModel((int)7425);
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureHalo);
        if (player != null) {
            AccessoryRenderHelper.translateToHeadLevel(player, partialTicks);
        }
        GlStateManager.translatef((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.rotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.translatef((float)-0.1f, (float)-0.5f, (float)-0.1f);
        if (player != null) {
            GlStateManager.rotatef((float)((float)player.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.rotatef((float)Botania.proxy.getWorldElapsedTicks(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        Tessellator tes = Tessellator.func_178181_a();
        ShaderHelper.useShader(ShaderHelper.halo);
        tes.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tes.func_178180_c().func_181662_b(-0.75, 0.0, -0.75).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_178180_c().func_181662_b(-0.75, 0.0, 0.75).func_187315_a(0.0, 1.0).func_181675_d();
        tes.func_178180_c().func_181662_b(0.75, 0.0, 0.75).func_187315_a(1.0, 1.0).func_181675_d();
        tes.func_178180_c().func_181662_b(0.75, 0.0, -0.75).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        ShaderHelper.releaseShader();
        GlStateManager.enableLighting();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableCull();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHUD(PlayerEntity player, ItemStack stack) {
        int xo;
        int u = Math.max(1, ItemFlightTiara.getVariant(stack)) * 9 - 9;
        int v = 0;
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(textureHud);
        int x = xo = mc.field_195558_d.func_198107_o() / 2 + 10;
        int y = mc.field_195558_d.func_198087_p() - ForgeIngameGui.right_height;
        ForgeIngameGui.right_height += 10;
        int left = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, 1200);
        int segTime = 120;
        int segs = left / segTime + 1;
        int last = left % segTime;
        for (int i = 0; i < segs; ++i) {
            float trans = 1.0f;
            if (i == segs - 1) {
                trans = (float)last / (float)segTime;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((int)770, (int)771);
                GlStateManager.disableAlphaTest();
            }
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
            RenderHelper.drawTexturedModalRect(x, y, 0.0f, u, v, 9, 9);
            x += 8;
        }
        if (player.field_71075_bZ.field_75100_b) {
            int width = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (width > 0) {
                AbstractGui.fill((int)xo, (int)(y - 2), (int)(xo + 80), (int)(y - 1), (int)-2013265920);
            }
            AbstractGui.fill((int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
        }
        GlStateManager.enableAlphaTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
    }

    public static int getVariant(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_VARIANT, 0);
    }
}

