/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBaubleCosmetic
extends ItemBauble
implements ICosmeticBauble {
    private final Variant variant;
    public static final int SUBTYPES = Variant.values().length;

    public ItemBaubleCosmetic(Variant variant, Item.Properties props) {
        super(props);
        this.variant = variant;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        if (this.variant == Variant.THINKING_HAND) {
            stacks.add(new TranslationTextComponent("botaniamisc.cosmeticThinking", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            stacks.add(new TranslationTextComponent("botaniamisc.cosmeticBauble", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        super.addHiddenTooltip(stack, world, stacks, flags);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        Variant variant = ((ItemBaubleCosmetic)stack.func_77973_b()).variant;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        if (variant.isHead) {
            AccessoryRenderHelper.translateToHeadLevel(player, partialTicks);
            AccessoryRenderHelper.translateToFace();
            AccessoryRenderHelper.defaultTransforms();
            switch (variant) {
                case RED_GLASSES: 
                case ENGINEER_GOGGLES: {
                    ItemBaubleCosmetic.scale(1.25f);
                    GlStateManager.translatef((float)0.0f, (float)-0.085f, (float)0.045f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case EYEPATCH: {
                    ItemBaubleCosmetic.scale(0.55f);
                    GlStateManager.translatef((float)-0.45f, (float)-0.25f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case WICKED_EYEPATCH: {
                    ItemBaubleCosmetic.scale(0.55f);
                    GlStateManager.translatef((float)0.45f, (float)-0.25f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case RED_RIBBONS: {
                    ItemBaubleCosmetic.scale(0.9f);
                    GlStateManager.translatef((float)0.0f, (float)0.75f, (float)1.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case PINK_FLOWER_BUD: {
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.4f, (float)0.6f, (float)0.45f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case POLKA_DOTTED_BOWS: {
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.65f, (float)0.3f, (float)0.5f);
                    ItemBaubleCosmetic.renderItem(stack);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case BLUE_BUTTERFLY: {
                    GlStateManager.translatef((float)-0.75f, (float)0.1f, (float)1.0f);
                    GlStateManager.pushMatrix();
                    GlStateManager.rotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    GlStateManager.popMatrix();
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-0.75f);
                    GlStateManager.rotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case CAT_EARS: {
                    GlStateManager.translatef((float)0.0f, (float)0.25f, (float)0.25f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case GOOGLY_EYES: {
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.scalef((float)1.5f, (float)1.5f, (float)1.0f);
                    GlStateManager.translatef((float)0.0f, (float)-0.05f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case CLOCK_EYE: {
                    ItemBaubleCosmetic.scale(0.75f);
                    GlStateManager.translatef((float)-0.25f, (float)-0.1f, (float)0.0f);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case UNICORN_HORN: {
                    ItemBaubleCosmetic.scale(1.25f);
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.4f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case DEVIL_HORNS: {
                    GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.25f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case HYPER_PLUS: {
                    ItemBaubleCosmetic.scale(0.35f);
                    GlStateManager.translatef((float)-0.7f, (float)1.0f, (float)-0.5f);
                    ItemBaubleCosmetic.renderItem(stack);
                    GlStateManager.translatef((float)1.45f, (float)0.0f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case ANCIENT_MASK: {
                    ItemBaubleCosmetic.scale(1.25f);
                    GlStateManager.translatef((float)0.0f, (float)0.025f, (float)0.01f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case EERIE_MASK: {
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case ALIEN_ANTENNA: {
                    ItemBaubleCosmetic.scale(0.9f);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.75f, (float)-1.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case ANAGLYPH_GLASSES: {
                    ItemBaubleCosmetic.scale(1.25f);
                    GlStateManager.translatef((float)0.0f, (float)-0.025f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case ORANGE_SHADES: {
                    ItemBaubleCosmetic.scale(1.25f);
                    GlStateManager.translatef((float)0.0f, (float)0.04f, (float)0.0f);
                    GlStateManager.enableBlend();
                    GlStateManager.blendFunc((int)770, (int)771);
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case GROUCHO_GLASSES: {
                    ItemBaubleCosmetic.scale(1.5f);
                    GlStateManager.translatef((float)0.0f, (float)-0.2125f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case THICK_EYEBROWS: {
                    ItemBaubleCosmetic.scale(0.5f);
                    GlStateManager.translatef((float)-0.4f, (float)0.05f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)-0.775f, (float)0.0f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case TINY_POTATO_MASK: {
                    ItemBaubleCosmetic.scale(1.25f);
                    GlStateManager.translatef((float)0.0f, (float)0.025f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case QUESTGIVER_MARK: {
                    ItemBaubleCosmetic.scale(0.8f);
                    GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.3f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case THINKING_HAND: {
                    ItemBaubleCosmetic.scale(0.9f);
                    GlStateManager.translatef((float)0.2f, (float)-0.5f, (float)0.0f);
                    GlStateManager.scalef((float)-1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.rotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
            }
        } else {
            AccessoryRenderHelper.rotateIfSneaking(player);
            AccessoryRenderHelper.translateToChest();
            AccessoryRenderHelper.defaultTransforms();
            switch (variant) {
                case BLACK_BOWTIE: {
                    GlStateManager.translatef((float)0.0f, (float)0.15f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case BLACK_TIE: 
                case PUFFY_SCARF: {
                    GlStateManager.translatef((float)0.0f, (float)-0.15f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case WITCH_PIN: {
                    ItemBaubleCosmetic.scale(0.35f);
                    GlStateManager.translatef((float)-0.35f, (float)0.35f, (float)0.15f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case DEVIL_TAIL: {
                    GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.5f, (float)-0.75f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case KAMUI_EYE: {
                    ItemBaubleCosmetic.scale(0.9f);
                    GlStateManager.translatef((float)0.9f, (float)0.35f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    GlStateManager.translatef((float)-1.3f, (float)-0.5f, (float)0.5f);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    ItemBaubleCosmetic.renderKamuiBlack(stack);
                    break;
                }
                case FOUR_LEAF_CLOVER: {
                    ItemBaubleCosmetic.scale(0.5f);
                    GlStateManager.translatef((float)0.35f, (float)0.3f, (float)-0.075f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case BOTANIST_EMBLEM: {
                    ItemBaubleCosmetic.scale(0.5f);
                    GlStateManager.translatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
                case LUSITANIC_SHIELD: {
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.035f, (float)-0.2f, (float)0.55f);
                    GlStateManager.rotatef((float)8.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ItemBaubleCosmetic.renderItem(stack);
                    break;
                }
            }
        }
    }

    public static void scale(float f) {
        GlStateManager.scalef((float)f, (float)f, (float)f);
    }

    public static void renderItem(ItemStack stack) {
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.popMatrix();
    }

    private static void renderKamuiBlack(ItemStack stack) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.pushMatrix();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
        ItemBaubleCosmetic.renderModel(model, stack, -16777140);
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
    }

    private static void renderModel(IBakedModel model, ItemStack stack, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (Direction enumfacing : Direction.values()) {
            ItemBaubleCosmetic.renderQuads(worldrenderer, model.func_200117_a(null, enumfacing, field_77697_d), color, stack);
        }
        ItemBaubleCosmetic.renderQuads(worldrenderer, model.func_200117_a(null, null, field_77697_d), color, stack);
        tessellator.func_78381_a();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static enum Variant {
        BLACK_BOWTIE,
        BLACK_TIE,
        RED_GLASSES,
        PUFFY_SCARF,
        ENGINEER_GOGGLES(true),
        EYEPATCH(true),
        WICKED_EYEPATCH(true),
        RED_RIBBONS(true),
        PINK_FLOWER_BUD(true),
        POLKA_DOTTED_BOWS(true),
        BLUE_BUTTERFLY(true),
        CAT_EARS(true),
        WITCH_PIN,
        DEVIL_TAIL,
        KAMUI_EYE,
        GOOGLY_EYES(true),
        FOUR_LEAF_CLOVER,
        CLOCK_EYE(true),
        UNICORN_HORN(true),
        DEVIL_HORNS(true),
        HYPER_PLUS(true),
        BOTANIST_EMBLEM,
        ANCIENT_MASK(true),
        EERIE_MASK(true),
        ALIEN_ANTENNA(true),
        ANAGLYPH_GLASSES(true),
        ORANGE_SHADES(true),
        GROUCHO_GLASSES(true),
        THICK_EYEBROWS(true),
        LUSITANIC_SHIELD,
        TINY_POTATO_MASK(true),
        QUESTGIVER_MARK(true),
        THINKING_HAND(true);

        private final boolean isHead;

        private Variant(boolean isHead) {
            this.isHead = isHead;
        }

        private Variant() {
            this(false);
        }
    }
}

