/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemBrewBase
extends ItemMod
implements IBrewItem {
    private static final String TAG_BREW_KEY = "brewKey";
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private final int swigs;
    private final int drinkSpeed;
    private final Supplier<Item> baseItem;

    public ItemBrewBase(Item.Properties builder, int swigs, int drinkSpeed, Supplier<Item> baseItem) {
        super(builder);
        this.swigs = swigs;
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
        this.func_185043_a(new ResourceLocation("botania", "swigs_taken"), (stack, world, entity) -> swigs - this.getSwigsLeft(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return this.drinkSpeed;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, LivingEntity living) {
        if (!world.field_72995_K) {
            for (EffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                EffectInstance newEffect = new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), true, true);
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)living, (Entity)living, living, newEffect.func_76458_c(), 1.0);
                    continue;
                }
                living.func_195064_c(newEffect);
            }
            if (world.field_73012_v.nextBoolean()) {
                world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof PlayerEntity && !((PlayerEntity)living).field_71075_bZ.field_75098_d) {
                if (swigs == 1) {
                    ItemStack result = new ItemStack((IItemProvider)this.baseItem.get());
                    if (!((PlayerEntity)living).field_71071_by.func_70441_a(result)) {
                        return result;
                    }
                    return ItemStack.field_190927_a;
                }
                this.setSwigsLeft(stack, swigs - 1);
            }
        }
        return stack;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemBrewBase.setBrew(stack, s);
                list.add((Object)stack);
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return new TranslationTextComponent(this.func_77658_a(), new Object[]{new TranslationTextComponent(this.getBrew(stack).getUnlocalizedName(stack), new Object[0]), new StringTextComponent(Integer.toString(this.getSwigsLeft(stack))).func_211708_a(TextFormatting.BOLD)});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(List<EffectInstance> list, List<ITextComponent> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent itextcomponent = new TranslationTextComponent(effectinstance.func_76453_d(), new Object[0]);
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c(), new Object[0]));
                }
                if (effectinstance.func_76459_b() > 20) {
                    itextcomponent.func_150258_a(" (").func_150258_a(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)durationFactor)).func_150258_a(")");
                }
                lores.add(itextcomponent.func_211708_a(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((ITextComponent)new StringTextComponent(""));
            lores.add(new TranslationTextComponent("potion.whenDrank", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.RED));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        ItemBrewBase.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), list, 1.0f);
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBrewBase.setBrew(stack, (brew == null ? BotaniaAPI.fallbackBrew : brew).getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    @Nonnull
    public static String getSubtype(ItemStack stack) {
        return stack.func_77942_o() ? ItemNBTHelper.getString(stack, TAG_BREW_KEY, "none") : "none";
    }

    public int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, this.swigs);
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }
}

