/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;

public class ItemSextant
extends ItemMod {
    public static final ResourceLocation MULTIBLOCK_ID = ResourceLocationHelper.prefix("sextant");
    private static final int MAX_RADIUS = 256;
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourceZ";

    public ItemSextant(Item.Properties builder) {
        super(builder);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack par1ItemStack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (this.func_77626_a(stack) - count < 10 || !(living instanceof PlayerEntity)) {
            return;
        }
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        if (y != -1) {
            Vector3 source = new Vector3(x, y, z);
            double radius = ItemSextant.calculateRadius(stack, (PlayerEntity)living);
            if (count % 10 == 0) {
                WispParticleData data = WispParticleData.wisp(0.3f, 0.0f, 1.0f, 1.0f, 1.0f);
                for (int i = 0; i < 360; ++i) {
                    float radian = (float)((double)i * Math.PI / 180.0);
                    double xp = (double)x + Math.cos(radian) * radius;
                    double zp = (double)z + Math.sin(radian) * radius;
                    living.field_70170_p.func_195594_a((IParticleData)data, xp + 0.5, source.y + 1.0, zp + 0.5, 0.0, (double)0.01f, 0.0);
                }
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int time) {
        if (!(living instanceof PlayerEntity)) {
            return;
        }
        double radius = ItemSextant.calculateRadius(stack, (PlayerEntity)living);
        if (1.0 < radius && radius <= 256.0) {
            IStateMatcher matcher = PatchouliAPI.instance.predicateMatcher(Blocks.field_150347_e, s -> !s.func_196958_f());
            int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
            int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, -1);
            int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
            int iradius = (int)radius + 1;
            if (y != -1) {
                HashMap<BlockPos, IStateMatcher> map = new HashMap<BlockPos, IStateMatcher>();
                for (int i = 0; i < iradius * 2 + 1; ++i) {
                    for (int j = 0; j < iradius * 2 + 1; ++j) {
                        int xp = x + i - iradius;
                        int zp = z + j - iradius;
                        if ((int)Math.floor(vazkii.botania.common.core.helper.MathHelper.pointDistancePlane(xp, zp, x, z)) != iradius - 1) continue;
                        map.put(new BlockPos(xp - x, 0, zp - z), matcher);
                    }
                }
                AbstractMultiblock sparse = (AbstractMultiblock)PatchouliAPI.instance.makeSparseMultiblock(map).setResourceLocation(MULTIBLOCK_ID);
                Botania.proxy.showMultiblock((IMultiblock)sparse, "r = " + (int)radius, new BlockPos(x, y, z), Rotation.NONE);
            }
        }
    }

    private void reset(World world, ItemStack stack) {
        ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, -1);
        if (world.field_72995_K) {
            Botania.proxy.clearSextantMultiblock();
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            BlockRayTraceResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 128.0, false);
            if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
                if (!world.field_72995_K) {
                    BlockPos pos = rtr.func_216350_a();
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_X, pos.func_177958_n());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, pos.func_177956_o());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Z, pos.func_177952_p());
                }
                player.func_184598_c(hand);
            }
        } else {
            this.reset(world, stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    private static double calculateRadius(ItemStack stack, PlayerEntity player) {
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        Vector3 source = new Vector3(x, y, z);
        WispParticleData data = WispParticleData.wisp(0.2f, 1.0f, 0.0f, 0.0f, 1.0f);
        player.field_70170_p.func_195594_a((IParticleData)data, source.x + 0.5, source.y + 1.0, source.z + 0.5, 0.0, (double)0.1f, 0.0);
        Vector3 centerVec = Vector3.fromEntityCenter((Entity)player);
        Vector3 diffVec = source.subtract(centerVec);
        Vector3 lookVec = new Vector3(player.func_70040_Z());
        double mul = diffVec.y / lookVec.y;
        lookVec = lookVec.multiply(mul).add(centerVec);
        lookVec = new Vector3(MathHelper.func_76128_c((double)lookVec.x), lookVec.y, MathHelper.func_76128_c((double)lookVec.z));
        return vazkii.botania.common.core.helper.MathHelper.pointDistancePlane(source.x, source.z, lookVec.x, lookVec.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHUD(PlayerEntity player, ItemStack stack) {
        ItemStack onUse = player.func_184607_cu();
        int time = player.func_184605_cv();
        if (onUse == stack && stack.func_77973_b().func_77626_a(stack) - time >= 10) {
            boolean inRange;
            double radius = ItemSextant.calculateRadius(stack, player);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int x = Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 + 30;
            int y = Minecraft.func_71410_x().field_195558_d.func_198087_p() / 2;
            String s = Integer.toString((int)radius);
            boolean bl = inRange = 0.0 < radius && radius <= 256.0;
            if (!inRange) {
                s = TextFormatting.RED + s;
            }
            font.func_175063_a(s, (float)(x - font.func_78256_a(s) / 2), (float)(y - 4), 0xFFFFFF);
            if (inRange) {
                radius += 4.0;
                GlStateManager.disableTexture();
                GlStateManager.lineWidth((float)3.0f);
                GL11.glBegin((int)3);
                GlStateManager.color4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (int i = 0; i < 361; ++i) {
                    float radian = (float)((double)i * Math.PI / 180.0);
                    double xp = (double)x + Math.cos(radian) * radius;
                    double yp = (double)y + Math.sin(radian) * radius;
                    GL11.glVertex2d((double)xp, (double)yp);
                }
                GL11.glEnd();
                GlStateManager.enableTexture();
            }
        }
    }
}

