/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.mana.ICompositableLens;

public class CompositeLensRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<CompositeLensRecipe> SERIALIZER = new SpecialRecipeSerializer(CompositeLensRecipe::new);

    public CompositeLensRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundLens = false;
        boolean foundSecondLens = false;
        boolean foundSlimeball = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICompositableLens && !foundSecondLens) {
                if (foundLens) {
                    foundSecondLens = true;
                    continue;
                }
                foundLens = true;
                continue;
            }
            if (stack.func_77973_b() == Items.field_151123_aH) {
                foundSlimeball = true;
                continue;
            }
            return false;
        }
        return foundSecondLens && foundSlimeball;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack lens = ItemStack.field_190927_a;
        ItemStack secondLens = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICompositableLens)) continue;
            if (lens.func_190926_b()) {
                lens = stack;
                continue;
            }
            secondLens = stack;
        }
        if (lens.func_77973_b() instanceof ICompositableLens) {
            ICompositableLens lensItem = (ICompositableLens)lens.func_77973_b();
            if (secondLens.func_190926_b() || !lensItem.canCombineLenses(lens, secondLens) || !lensItem.getCompositeLens(lens).func_190926_b() || !lensItem.getCompositeLens(secondLens).func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack lensCopy = lens.func_77946_l();
            lensItem.setCompositeLens(lensCopy, secondLens);
            return lensCopy;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 3;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

