/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.imc.OreWeightMessage;
import vazkii.botania.api.imc.PaintableBlockMessage;

public final class IMCHandler {
    public static void handle(InterModProcessEvent evt) {
        BotaniaAPI.oreWeights = IMCHandler.handleOreWeights(evt.getIMCStream("register_ore_weight"::equals));
        BotaniaAPI.oreWeightsNether = IMCHandler.handleOreWeights(evt.getIMCStream("register_nether_ore_weight"::equals));
        BotaniaAPI.paintableBlocks = IMCHandler.handlePaintable(evt.getIMCStream("register_paintable_block"::equals));
    }

    private static Map<ResourceLocation, Integer> handleOreWeights(Stream<InterModComms.IMCMessage> msgs) {
        Map<ResourceLocation, Integer> map = msgs.filter(msg -> msg.getMessageSupplier().get() instanceof OreWeightMessage).map(msg -> (OreWeightMessage)msg.getMessageSupplier().get()).collect(Collectors.toMap(OreWeightMessage::getOre, OreWeightMessage::getWeight));
        return ImmutableMap.copyOf(map);
    }

    private static Map<IRegistryDelegate<Block>, Function<DyeColor, Block>> handlePaintable(Stream<InterModComms.IMCMessage> msgs) {
        Map<IRegistryDelegate, Function> map = msgs.filter(msg -> msg.getMessageSupplier().get() instanceof PaintableBlockMessage).map(msg -> (PaintableBlockMessage)msg.getMessageSupplier().get()).collect(Collectors.toMap(PaintableBlockMessage::getBlock, PaintableBlockMessage::getTransformer));
        return ImmutableMap.copyOf(map);
    }
}

