/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestDefaultMatchers;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.TileMod;

public class TileCorporeaRetainer
extends TileMod {
    @ObjectHolder(value="botania:corporea_retainer")
    public static TileEntityType<TileCorporeaRetainer> TYPE;
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    public static final Map<String, Function<CompoundNBT, ICorporeaRequestMatcher>> corporeaMatcherDeserializers;
    public static final Map<Class<?>, String> corporeaMatcherSerializers;
    private BlockPos requestPos = BlockPos.field_177992_a;
    @Nullable
    private ICorporeaRequestMatcher request;
    private int requestCount;
    private int compValue;

    public TileCorporeaRetainer() {
        super(TYPE);
    }

    public void setPendingRequest(BlockPos pos, ICorporeaRequestMatcher request, int requestCount) {
        if (this.hasPendingRequest()) {
            return;
        }
        this.requestPos = pos;
        this.request = request;
        this.requestCount = requestCount;
        this.compValue = CorporeaHelper.signalStrengthForRequestSize(requestCount);
        this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    public boolean hasPendingRequest() {
        return this.request != null;
    }

    public void fulfilRequest() {
        InvWithLocation inv;
        if (!this.hasPendingRequest()) {
            return;
        }
        ICorporeaSpark spark = CorporeaHelper.getSparkForBlock(this.field_145850_b, this.requestPos);
        if (spark != null && (inv = spark.getSparkInventory()) != null && inv.world.func_175625_s(inv.pos) instanceof ICorporeaRequestor) {
            ICorporeaRequestor requestor = (ICorporeaRequestor)inv.world.func_175625_s(inv.pos);
            requestor.doCorporeaRequest(this.request, this.requestCount, spark);
            this.request = null;
            this.requestCount = 0;
            this.compValue = 0;
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        super.writePacketNBT(cmp);
        cmp.func_74768_a(TAG_REQUEST_X, this.requestPos.func_177958_n());
        cmp.func_74768_a(TAG_REQUEST_Y, this.requestPos.func_177956_o());
        cmp.func_74768_a(TAG_REQUEST_Z, this.requestPos.func_177952_p());
        String reqType = this.request != null ? corporeaMatcherSerializers.getOrDefault(this.request.getClass(), "") : "";
        cmp.func_74778_a(TAG_REQUEST_TYPE, reqType);
        if (reqType.length() > 0) {
            this.request.writeToNBT(cmp);
        }
        cmp.func_74768_a(TAG_REQUEST_COUNT, this.requestCount);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        super.readPacketNBT(cmp);
        int x = cmp.func_74762_e(TAG_REQUEST_X);
        int y = cmp.func_74762_e(TAG_REQUEST_Y);
        int z = cmp.func_74762_e(TAG_REQUEST_Z);
        this.requestPos = new BlockPos(x, y, z);
        String reqType = cmp.func_74779_i(TAG_REQUEST_TYPE);
        this.request = corporeaMatcherDeserializers.containsKey(reqType) ? corporeaMatcherDeserializers.get(reqType).apply(cmp) : null;
        this.requestCount = cmp.func_74762_e(TAG_REQUEST_COUNT);
    }

    public static void addCorporeaRequestMatcher(String type, Class<?> clazz, Function<CompoundNBT, ICorporeaRequestMatcher> deserializer) {
        corporeaMatcherSerializers.put(clazz, type);
        corporeaMatcherDeserializers.put(type, deserializer);
    }

    static {
        corporeaMatcherDeserializers = new HashMap<String, Function<CompoundNBT, ICorporeaRequestMatcher>>();
        corporeaMatcherSerializers = new HashMap();
        TileCorporeaRetainer.addCorporeaRequestMatcher("string", CorporeaRequestDefaultMatchers.CorporeaStringMatcher.class, CorporeaRequestDefaultMatchers.CorporeaStringMatcher::createFromNBT);
        TileCorporeaRetainer.addCorporeaRequestMatcher("item_stack", CorporeaRequestDefaultMatchers.CorporeaItemStackMatcher.class, CorporeaRequestDefaultMatchers.CorporeaItemStackMatcher::createFromNBT);
    }
}

