/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.common.block.tile.TileMod;

public abstract class TileSimpleInventory
extends TileMod {
    protected SimpleItemStackHandler itemHandler = this.createItemHandler();
    private final LazyOptional<IItemHandler> automationItemHandler = LazyOptional.of(() -> this.itemHandler);

    public TileSimpleInventory(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void readPacketNBT(CompoundNBT par1NBTTagCompound) {
        this.itemHandler = this.createItemHandler();
        this.itemHandler.deserializeNBT(par1NBTTagCompound);
    }

    @Override
    public void writePacketNBT(CompoundNBT par1NBTTagCompound) {
        par1NBTTagCompound.func_197643_a(this.itemHandler.serializeNBT());
    }

    public abstract int getSizeInventory();

    protected SimpleItemStackHandler createItemHandler() {
        return new SimpleItemStackHandler(this, true);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.automationItemHandler);
    }

    protected static class SimpleItemStackHandler
    extends ItemStackHandler {
        private final boolean allowWrite;
        private final TileSimpleInventory tile;

        public SimpleItemStackHandler(TileSimpleInventory inv, boolean allowWrite) {
            super(inv.getSizeInventory());
            this.allowWrite = allowWrite;
            this.tile = inv;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.allowWrite) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.allowWrite) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public void onContentsChanged(int slot) {
            this.tile.func_70296_d();
        }
    }
}

