/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class TileCraftCrate
extends TileOpenCrate {
    @ObjectHolder(value="botania:crafty_crate")
    public static TileEntityType<TileCraftCrate> TYPE;
    private static final String TAG_PATTERN = "pattern";
    private int signal = 0;

    public TileCraftCrate() {
        super(TYPE);
    }

    @Override
    public int getSizeInventory() {
        return 10;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, true){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot != 9 && !TileCraftCrate.this.isLocked(slot)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    public CratePattern getPattern() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() != ModBlocks.craftCrate) {
            return CratePattern.NONE;
        }
        return (CratePattern)((Object)state.func_177229_b(BotaniaStateProps.CRATE_PATTERN));
    }

    private boolean isLocked(int slot) {
        return this.getPattern().openSlots.get(slot) == false;
    }

    @Override
    public void func_73660_a() {
        int newSignal;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canEject() && this.isFull() && this.craft(true)) {
            this.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (this.isLocked(newSignal) || !this.itemHandler.getStackInSlot(newSignal).func_190926_b()); ++newSignal) {
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    private boolean craft(boolean fullCheck) {
        if (fullCheck && !this.isFull()) {
            return false;
        }
        CraftingInventory craft = new CraftingInventory(new Container(ContainerType.field_221518_l, -1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < craft.func_70302_i_(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || this.isLocked(i) || stack.func_77973_b() == ModItems.placeholder) continue;
            craft.func_70299_a(i, stack);
        }
        Optional matchingRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craft, this.field_145850_b);
        matchingRecipe.ifPresent(recipe -> {
            this.itemHandler.setStackInSlot(9, recipe.func_77572_b((IInventory)craft));
            NonNullList remainders = recipe.func_179532_b((IInventory)craft);
            for (int i = 0; i < craft.func_70302_i_(); ++i) {
                ItemStack s = (ItemStack)remainders.get(i);
                if (!this.itemHandler.getStackInSlot(i).func_190926_b() && this.itemHandler.getStackInSlot(i).func_77973_b() == ModItems.placeholder) continue;
                this.itemHandler.setStackInSlot(i, s);
            }
        });
        return matchingRecipe.isPresent();
    }

    boolean isFull() {
        for (int i = 0; i < 9; ++i) {
            if (this.isLocked(i) || !this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                this.eject(stack, false);
            }
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    @Override
    public boolean onWanded(World world, PlayerEntity player, ItemStack stack) {
        if (!world.field_72995_K && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    @Override
    public int getSignal() {
        return this.signal;
    }
}

