/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.core.helper.MathHelper;

@Mod.EventBusSubscriber(modid="botania")
public class SubTileVinculotus
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:vinculotus")
    public static TileEntityType<SubTileVinculotus> TYPE;
    public static final Map<SubTileVinculotus, BlockPos> existingFlowers;
    private static final int RANGE = 64;

    public SubTileVinculotus() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        BlockPos pos;
        super.tickFlower();
        if (!(this.func_145831_w().field_72995_K || (pos = existingFlowers.get(this)) != null && pos.equals((Object)this.getEffectivePos()))) {
            existingFlowers.put(this, this.getEffectivePos());
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 64.0);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 680017;
    }

    @Override
    public int getMaxMana() {
        return 500;
    }

    @SubscribeEvent
    public static void onEndermanTeleport(EnderTeleportEvent event) {
        int cost = 50;
        if (event.getEntityLiving() instanceof EndermanEntity) {
            ArrayList<ImmutablePair> possibleFlowers = new ArrayList<ImmutablePair>();
            for (Map.Entry<SubTileVinculotus, BlockPos> e : existingFlowers.entrySet()) {
                double z;
                double y;
                double x;
                SubTileVinculotus flower = e.getKey();
                BlockPos activePos = e.getValue();
                if (flower == null || flower.redstoneSignal > 0 || flower.getMana() <= cost || flower.func_145831_w() != event.getEntityLiving().field_70170_p || flower.func_145831_w().func_175625_s(flower.getEffectivePos()) != flower || !(MathHelper.pointDistanceSpace(x = (double)activePos.func_177958_n() + 0.5, y = (double)activePos.func_177956_o() + 1.5, z = (double)activePos.func_177952_p() + 0.5, event.getTargetX(), event.getTargetY(), event.getTargetZ()) < 64.0f)) continue;
                possibleFlowers.add(ImmutablePair.of((Object)flower, (Object)activePos));
            }
            if (!possibleFlowers.isEmpty()) {
                Pair p = (Pair)possibleFlowers.get(event.getEntityLiving().field_70170_p.field_73012_v.nextInt(possibleFlowers.size()));
                SubTileVinculotus flower = (SubTileVinculotus)p.getLeft();
                BlockPos activePos = (BlockPos)p.getRight();
                double x = (double)activePos.func_177958_n() + 0.5;
                double y = (double)activePos.func_177956_o() + 1.5;
                double z = (double)activePos.func_177952_p() + 0.5;
                event.setTargetX(x + Math.random() * 3.0 - 1.0);
                event.setTargetY(y);
                event.setTargetZ(z + Math.random() * 3.0 - 1.0);
                flower.addMana(-cost);
                flower.sync();
            }
        }
    }

    static {
        existingFlowers = new WeakHashMap<SubTileVinculotus, BlockPos>();
    }
}

