/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.item.DyeColor;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;

public class BlockModFlower
extends FlowerBlock
implements IGrowable {
    public final DyeColor color;

    protected BlockModFlower(DyeColor color, Block.Properties builder) {
        super(BlockModFlower.effectForFlower(color), 4, builder);
        this.color = color;
    }

    private static Effect effectForFlower(DyeColor color) {
        switch (color) {
            case WHITE: {
                return Effects.field_76424_c;
            }
            case ORANGE: {
                return Effects.field_76426_n;
            }
            case MAGENTA: {
                return Effects.field_76419_f;
            }
            case LIGHT_BLUE: {
                return Effects.field_76430_j;
            }
            case YELLOW: {
                return Effects.field_76444_x;
            }
            case LIME: {
                return Effects.field_76436_u;
            }
            case PINK: {
                return Effects.field_76428_l;
            }
            case GRAY: {
                return Effects.field_76429_m;
            }
            case LIGHT_GRAY: {
                return Effects.field_76437_t;
            }
            case CYAN: {
                return Effects.field_76427_o;
            }
            case PURPLE: {
                return Effects.field_76431_k;
            }
            case BLUE: {
                return Effects.field_76439_r;
            }
            case BROWN: {
                return Effects.field_82731_v;
            }
            case GREEN: {
                return Effects.field_76438_s;
            }
            case RED: {
                return Effects.field_76420_g;
            }
            case BLACK: {
                return Effects.field_76440_q;
            }
        }
        return Effects.field_76428_l;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        int hex = this.color.field_193351_w;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Vec3d offset = state.func_191059_e((IBlockReader)world, pos);
        double x = (double)pos.func_177958_n() + offset.field_72450_a;
        double y = (double)pos.func_177956_o() + offset.field_72448_b;
        double z = (double)pos.func_177952_p() + offset.field_72449_c;
        if (rand.nextDouble() < (Double)ConfigHandler.CLIENT.flowerParticleFrequency.get()) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.func_195594_a((IParticleData)data, x + 0.3 + (double)rand.nextFloat() * 0.5, y + 0.5 + (double)rand.nextFloat() * 0.5, z + 0.3 + (double)rand.nextFloat() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean fuckifiknow) {
        return world.func_180495_p(pos.func_177984_a()).isAir(world, pos);
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.func_176473_a((IBlockReader)world, pos, state, false);
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Block block = ModBlocks.getDoubleFlower(this.color);
        if (block instanceof DoublePlantBlock) {
            ((DoublePlantBlock)block).func_196390_a((IWorld)world, pos, 3);
        }
    }
}

