/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.platform.GLX;
import java.nio.FloatBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public class RenderDoppleganger
extends BipedRenderer<EntityDoppleganger, BipedModel<EntityDoppleganger>> {
    private static final float DEFAULT_GRAIN_INTENSITY = 0.05f;
    private static final float DEFAULT_DISFIGURATION = 0.025f;
    private static float grainIntensity = 0.05f;
    private static float disfiguration = 0.025f;
    public static final ShaderCallback callback = shader -> {
        int disfigurationUniform = GLX.glGetUniformLocation((int)shader, (CharSequence)"disfiguration");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, disfiguration);
        GLX.glUniform1((int)disfigurationUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
        int grainIntensityUniform = GLX.glGetUniformLocation((int)shader, (CharSequence)"grainIntensity");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, grainIntensity);
        GLX.glUniform1((int)grainIntensityUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
    };
    public static final ShaderCallback defaultCallback = shader -> {
        int disfigurationUniform = GLX.glGetUniformLocation((int)shader, (CharSequence)"disfiguration");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, 0.025f);
        GLX.glUniform1((int)disfigurationUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
        int grainIntensityUniform = GLX.glGetUniformLocation((int)shader, (CharSequence)"grainIntensity");
        ShaderHelper.FLOAT_BUF.position(0);
        ShaderHelper.FLOAT_BUF.put(0, 0.05f);
        GLX.glUniform1((int)grainIntensityUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
    };

    public RenderDoppleganger(EntityRendererManager renderManager) {
        super(renderManager, (BipedModel)new PlayerModel(0.0f, false), 0.0f);
    }

    public void doRender(@Nonnull EntityDoppleganger dopple, double par2, double par4, double par6, float par8, float par9) {
        int invulTime = dopple.getInvulTime();
        if (invulTime > 0) {
            grainIntensity = invulTime > 20 ? 1.0f : (float)invulTime * 0.05f;
            disfiguration = grainIntensity * 0.3f;
        } else {
            disfiguration = (0.025f + (float)dopple.field_70737_aN * 0.0425f) / 2.0f;
            grainIntensity = 0.05f + (float)dopple.field_70737_aN * 0.085f;
        }
        ShaderHelper.useShader(ShaderHelper.doppleganger, callback);
        super.func_76986_a((MobEntity)dopple, par2, par4, par6, par8, par9);
        ShaderHelper.releaseShader();
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityDoppleganger entity) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.func_175606_aa() instanceof AbstractClientPlayerEntity)) {
            return DefaultPlayerSkin.func_177334_a((UUID)entity.func_110124_au());
        }
        return ((AbstractClientPlayerEntity)mc.func_175606_aa()).func_110306_p();
    }
}

