/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.entity.EntityBabylonWeapon;

public class RenderBabylonWeapon
extends EntityRenderer<EntityBabylonWeapon> {
    private static final ResourceLocation babylon = new ResourceLocation("botania:textures/misc/babylon.png");

    public RenderBabylonWeapon(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void doRender(@Nonnull EntityBabylonWeapon weapon, double par2, double par4, double par6, float par8, float par9) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)par2, (double)par4, (double)par6);
        GlStateManager.rotatef((float)weapon.getRotation(), (float)0.0f, (float)1.0f, (float)0.0f);
        int live = weapon.getLiveTicks();
        int delay = weapon.getDelay();
        float charge = Math.min(10.0f, (float)Math.max(live, weapon.getChargeTicks()) + par9);
        float chargeMul = charge / 10.0f;
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.pushMatrix();
        float s = 1.5f;
        GlStateManager.scalef((float)s, (float)s, (float)s);
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        TextureAtlasSprite icon = MiscellaneousIcons.INSTANCE.kingKeyWeaponIcons[weapon.getVariety()];
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)chargeMul);
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
        GlStateManager.disableLighting();
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.popMatrix();
        GlStateManager.disableCull();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)chargeMul);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(babylon);
        Tessellator tes = Tessellator.func_178181_a();
        ShaderHelper.useShader(ShaderHelper.halo);
        Random rand = new Random(weapon.func_110124_au().getMostSignificantBits());
        GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)(-0.3f + rand.nextFloat() * 0.1f), (float)1.0f);
        s = chargeMul;
        if (live > delay) {
            s -= Math.min(1.0f, ((float)(live - delay) + par9) * 0.2f);
        }
        GlStateManager.scalef((float)(s *= 2.0f), (float)s, (float)s);
        GlStateManager.rotatef((float)(charge * 9.0f + ((float)weapon.field_70173_aa + par9) * 0.5f + rand.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        tes.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tes.func_178180_c().func_181662_b(-1.0, 0.0, -1.0).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_178180_c().func_181662_b(-1.0, 0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        tes.func_178180_c().func_181662_b(1.0, 0.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        tes.func_178180_c().func_181662_b(1.0, 0.0, -1.0).func_187315_a(1.0, 0.0).func_181675_d();
        tes.func_78381_a();
        ShaderHelper.releaseShader();
        GlStateManager.enableLighting();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityBabylonWeapon entity) {
        return AtlasTexture.field_110575_b;
    }
}

