/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.puredaisy;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.common.block.ModSubtiles;

public class PureDaisyRecipeCategory
implements IRecipeCategory<RecipePureDaisy> {
    public static final ResourceLocation UID = new ResourceLocation("botania", "pure_daisy");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public PureDaisyRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 64);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.pureDaisy", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModSubtiles.pureDaisy));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends RecipePureDaisy> getRecipeClass() {
        return RecipePureDaisy.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RecipePureDaisy recipe, IIngredients iIngredients) {
        if (recipe.getInput() instanceof Tag) {
            Collection all = ((Tag)recipe.getInput()).func_199885_a();
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(all.stream().map(ItemStack::new).filter(s -> !s.func_190926_b()).collect(Collectors.toList())));
        } else if (recipe.getInput() instanceof Block || recipe.getInput() instanceof BlockState) {
            BlockState state = recipe.getInput() instanceof BlockState ? (BlockState)recipe.getInput() : ((Block)recipe.getInput()).func_176223_P();
            Block b = state.func_177230_c();
            if (b instanceof FlowingFluidBlock) {
                iIngredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)((FlowingFluidBlock)b).getFluid(), 1000));
            } else if (b.func_199767_j() != Items.field_190931_a) {
                iIngredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)b));
            }
        }
        Block outBlock = recipe.getOutputState().func_177230_c();
        if (outBlock instanceof FlowingFluidBlock) {
            iIngredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)((FlowingFluidBlock)outBlock).getFluid(), 1000));
        } else if (outBlock.func_199767_j() != Items.field_190931_a) {
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)outBlock));
        }
    }

    public void draw(RecipePureDaisy recipe, double mouseX, double mouseY) {
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        this.overlay.draw(48, 0);
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipePureDaisy recipe, @Nonnull IIngredients ingredients) {
        boolean outputFluid;
        boolean inputFluid = !ingredients.getInputs(VanillaTypes.FLUID).isEmpty();
        boolean bl = outputFluid = !ingredients.getOutputs(VanillaTypes.FLUID).isEmpty();
        if (inputFluid) {
            recipeLayout.getFluidStacks().init(0, true, 40, 12, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        } else {
            recipeLayout.getItemStacks().init(0, true, 40, 12);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        recipeLayout.getItemStacks().init(1, true, 70, 12);
        recipeLayout.getItemStacks().set(1, new ItemStack((IItemProvider)ModSubtiles.pureDaisy));
        if (outputFluid) {
            recipeLayout.getFluidStacks().init(2, false, 99, 12, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        } else {
            recipeLayout.getItemStacks().init(2, false, 99, 12);
            recipeLayout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }
}

