/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.client.core.handler.RedStringRenderer;
import vazkii.botania.client.fx.FXLightning;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public class LightningHandler {
    private static final int BATCH_THRESHOLD = 200;
    private static final ResourceLocation outsideResource = new ResourceLocation("botania:textures/misc/wisp_large.png");
    private static final ResourceLocation insideResource = new ResourceLocation("botania:textures/misc/wisp_small.png");
    public static final Deque<FXLightning> queuedLightningBolts = new ArrayDeque<FXLightning>();

    private LightningHandler() {
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();
        profiler.func_76320_a("botania-particles");
        profiler.func_76320_a("redString");
        RedStringRenderer.renderAll();
        profiler.func_219895_b("lightning");
        float frame = event.getPartialTicks();
        ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        render.func_110577_a(outsideResource);
        int counter = 0;
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
        for (FXLightning bolt : queuedLightningBolts) {
            bolt.renderBolt(0, false);
            if (counter % 200 == 199) {
                tessellator.func_78381_a();
                tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
            }
            ++counter;
        }
        tessellator.func_78381_a();
        render.func_110577_a(insideResource);
        counter = 0;
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
        for (FXLightning bolt : queuedLightningBolts) {
            bolt.renderBolt(1, true);
            if (counter % 200 == 199) {
                tessellator.func_78381_a();
                tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181711_k);
            }
            ++counter;
        }
        tessellator.func_78381_a();
        queuedLightningBolts.clear();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.translated((double)interpPosX, (double)interpPosY, (double)interpPosZ);
        GlStateManager.popMatrix();
        profiler.func_76319_b();
        profiler.func_76319_b();
    }
}

