/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.TileSignature;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.core.handler.RedStringRenderer;
import vazkii.botania.common.block.subtile.functional.SubTileVinculotus;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.patchouli.client.book.gui.GuiBook;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public final class ClientTickHandler {
    public static int ticksWithLexicaOpen = 0;
    public static int pageFlipTicks = 0;
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float delta = 0.0f;
    public static float total = 0.0f;
    private static final Field RENDER_PARTIAL_TICKS_PAUSED = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_193996_ah");

    private ClientTickHandler() {
    }

    private static void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
            if (mc.func_147113_T()) {
                try {
                    partialTicks = ((Float)RENDER_PARTIAL_TICKS_PAUSED.get(mc)).floatValue();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        } else {
            ClientTickHandler.calcDelta();
        }
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            RedStringRenderer.tick();
            ItemsRemainingRenderHandler.tick();
            if (Minecraft.func_71410_x().field_71441_e == null) {
                ManaNetworkHandler.instance.clear();
                SubTileVinculotus.existingFlowers.clear();
            }
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ++ticksInGame;
                partialTicks = 0.0f;
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player != null && PlayerHelper.hasHeldItemClass((PlayerEntity)player, ModItems.twigWand)) {
                    for (TileSignature sig : ImmutableList.copyOf(ManaNetworkHandler.instance.getAllCollectorsInWorld((World)Minecraft.func_71410_x().field_71441_e))) {
                        TileEntity tile;
                        if (!sig.isRemote() || !((tile = sig.getTile()) instanceof IManaCollector)) continue;
                        ((IManaCollector)tile).onClientDisplayTick();
                    }
                }
            }
            int ticksToOpen = 10;
            Screen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GuiBook && ((GuiBook)gui).book.getBookItem().func_77973_b() == ModItems.lexicon) {
                if (ticksWithLexicaOpen < 0) {
                    ticksWithLexicaOpen = 0;
                }
                if (ticksWithLexicaOpen < ticksToOpen) {
                    ++ticksWithLexicaOpen;
                }
                if (pageFlipTicks > 0) {
                    --pageFlipTicks;
                }
            } else {
                pageFlipTicks = 0;
                if (ticksWithLexicaOpen > 0) {
                    if (ticksWithLexicaOpen > ticksToOpen) {
                        ticksWithLexicaOpen = ticksToOpen;
                    }
                    --ticksWithLexicaOpen;
                }
            }
            ClientTickHandler.calcDelta();
        }
    }

    public static void notifyPageChange() {
        if (pageFlipTicks == 0) {
            pageFlipTicks = 5;
        }
    }
}

