/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.api.boss.IBotaniaBoss;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="botania")
public final class BossBarHandler {
    public static final Set<IBotaniaBoss> bosses = Collections.newSetFromMap(new WeakHashMap());
    public static final ResourceLocation defaultBossBar = new ResourceLocation("botania:textures/gui/boss_bar.png");
    private static final BarCallback barUniformCallback = new BarCallback();

    private BossBarHandler() {
    }

    @SubscribeEvent
    public static void onBarRender(RenderGameOverlayEvent.BossInfo evt) {
        UUID infoUuid = evt.getBossInfo().func_186737_d();
        for (IBotaniaBoss currentBoss : bosses) {
            if (!currentBoss.getBossInfoUuid().equals(infoUuid)) continue;
            evt.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            Rectangle bgRect = currentBoss.getBossBarTextureRect();
            Rectangle fgRect = currentBoss.getBossBarHPTextureRect();
            String name = evt.getBossInfo().func_186744_e().func_150254_d();
            int c = Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2;
            int x = evt.getX();
            int y = evt.getY();
            int xf = x + (bgRect.width - fgRect.width) / 2;
            int yf = y + (bgRect.height - fgRect.height) / 2;
            int fw = (int)((double)fgRect.width * (double)evt.getBossInfo().func_186738_f());
            int tx = c - mc.field_71466_p.func_78256_a(name) / 2;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int auxHeight = currentBoss.bossBarRenderCallback(x, y);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            mc.field_71446_o.func_110577_a(currentBoss.getBossBarTexture());
            BossBarHandler.drawBar(currentBoss, x, y, bgRect.x, bgRect.y, bgRect.width, bgRect.height, true);
            BossBarHandler.drawBar(currentBoss, xf, yf, fgRect.x, fgRect.y, fw, fgRect.height, false);
            mc.field_71466_p.func_175063_a(name, (float)tx, (float)(y - 10), 10617228);
            GlStateManager.enableBlend();
            int n = Math.max(bgRect.height, fgRect.height) + auxHeight;
            mc.field_71466_p.getClass();
            evt.setIncrement(n + 9);
        }
    }

    private static void drawBar(IBotaniaBoss currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
        boolean useShader;
        int program = currentBoss.getBossBarShaderProgram(bg);
        boolean bl = useShader = program > 0;
        if (useShader) {
            ShaderCallback callback = currentBoss.getBossBarShaderCallback(bg, program);
            barUniformCallback.set(u, v, callback);
            ShaderHelper.useShader(program, barUniformCallback);
        }
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, u, v, w, h);
        if (useShader) {
            ShaderHelper.releaseShader();
        }
    }

    private static class BarCallback
    implements ShaderCallback {
        int x;
        int y;
        ShaderCallback callback;

        private BarCallback() {
        }

        @Override
        public void call(int shader) {
            int startXUniform = GLX.glGetUniformLocation((int)shader, (CharSequence)"startX");
            int startYUniform = GLX.glGetUniformLocation((int)shader, (CharSequence)"startY");
            GLX.glUniform1i((int)startXUniform, (int)this.x);
            GLX.glUniform1i((int)startYUniform, (int)this.y);
            if (this.callback != null) {
                this.callback.call(shader);
            }
        }

        void set(int x, int y, ShaderCallback callback) {
            this.x = x;
            this.y = y;
            this.callback = callback;
        }
    }
}

