/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;

public class RecipeManaInfusion {
    @ObjectHolder(value="botania:alchemy_catalyst")
    public static Block alchemy;
    @ObjectHolder(value="botania:conjuration_catalyst")
    public static Block conjuration;
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient input;
    private final int mana;
    @Nullable
    private BlockState catalystState;
    private final String group;

    public static RecipeManaInfusion conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
        RecipeManaInfusion ret = new RecipeManaInfusion(id, output, input, mana);
        ret.setCatalyst(conjuration.func_176223_P());
        return ret;
    }

    public static RecipeManaInfusion alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
        return RecipeManaInfusion.alchemy(id, output, input, mana, null);
    }

    public static RecipeManaInfusion alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group) {
        RecipeManaInfusion ret = new RecipeManaInfusion(id, output, input, mana, group);
        ret.setCatalyst(alchemy.func_176223_P());
        return ret;
    }

    public RecipeManaInfusion(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
        this(id, output, input, mana, null);
    }

    public RecipeManaInfusion(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.mana = mana;
        Preconditions.checkArgument((mana < 100000 ? 1 : 0) != 0);
        this.group = group == null ? "" : group;
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Nullable
    public BlockState getCatalyst() {
        return this.catalystState;
    }

    public void setCatalyst(BlockState catalyst) {
        this.catalystState = catalyst;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getManaToConsume() {
        return this.mana;
    }

    public String getGroup() {
        return this.group;
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        this.input.func_199564_a(buf);
        buf.writeItemStack(this.output, false);
        buf.func_150787_b(this.mana);
        buf.writeInt(this.catalystState == null ? -1 : Block.func_196246_j((BlockState)this.catalystState));
        buf.func_180714_a(this.group);
    }

    public static RecipeManaInfusion read(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buf);
        ItemStack output = buf.func_150791_c();
        int mana = buf.func_150792_a();
        int catalystId = buf.readInt();
        String group = buf.func_218666_n();
        RecipeManaInfusion ret = new RecipeManaInfusion(id, output, input, mana, group);
        ret.setCatalyst(catalystId == -1 ? null : Block.func_196257_b((int)catalystId));
        return ret;
    }
}

