/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;

public class RecipeBrew {
    private final ResourceLocation id;
    private final Brew brew;
    private final ImmutableList<Ingredient> inputs;

    public RecipeBrew(ResourceLocation id, Brew brew, Ingredient ... inputs) {
        this.id = id;
        this.brew = brew;
        this.inputs = ImmutableList.copyOf((Object[])inputs);
    }

    public boolean matches(IItemHandler inv) {
        ItemStack stack;
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.getSlots() && !(stack = inv.getStackInSlot(i)).func_190926_b(); ++i) {
            if (stack.func_77973_b() instanceof IBrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                Ingredient input = (Ingredient)iter.next();
                if (!input.test(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<Ingredient> getInputs() {
        return new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
    }

    public Brew getBrew() {
        return this.brew;
    }

    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    public ItemStack getOutput(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IBrewContainer)) {
            return new ItemStack((IItemProvider)Items.field_151069_bo);
        }
        IBrewContainer container = (IBrewContainer)stack.func_77973_b();
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * this.brew.hashCode() ^ this.inputs.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RecipeBrew && this.brew == ((RecipeBrew)o).brew && this.inputs.equals(((RecipeBrew)o).inputs);
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        buf.func_180714_a(this.brew.getKey());
        buf.func_150787_b(this.inputs.size());
        for (Ingredient input : this.inputs) {
            input.func_199564_a(buf);
        }
    }

    public static RecipeBrew read(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        Brew brew = BotaniaAPI.getBrewFromKey(buf.func_218666_n());
        Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
        }
        return new RecipeBrew(id, brew, inputs);
    }
}

