/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.util.json.PaintingEntry;

public class PaintingPackReader {
    private static ArrayList<PaintingEntry> addedPaintings = new ArrayList();

    public PaintingPackReader registerReloadListener() {
        Paintings.LOG.info("Registering Resource Reloading");
        IResourceManager rm = Minecraft.func_71410_x().func_195551_G();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
                if (resourcePredicate.test(VanillaResourceType.TEXTURES)) {
                    this.loadFromJson();
                }
            }));
        }
        return this;
    }

    public PaintingPackReader init() {
        Paintings.LOG.info("loading json file and contents for paintings.");
        this.loadFromJson();
        return this;
    }

    private void loadFromJson() {
        try {
            File directory = new File("./paintings");
            if (!directory.exists()) {
                directory.mkdir();
                try (InputStream is = this.getClass().getResourceAsStream("/assets/paintings/paintings.json");
                     FileOutputStream os = new FileOutputStream("./paintings/paintings.json");){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, length);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (File jsonfile : directory.listFiles()) {
                if (!jsonfile.isFile() || !jsonfile.getName().endsWith(".json")) continue;
                FileInputStream stream = new FileInputStream(jsonfile);
                Gson gson = new GsonBuilder().create();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                JsonObject json = je.getAsJsonObject();
                JsonArray array = json.getAsJsonArray("paintings");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject jsonObject = array.get(i).getAsJsonObject();
                    String textureName = jsonObject.get("name").getAsString();
                    int sizeX = 0;
                    int sizeY = 0;
                    int sizeSquare = 0;
                    if (jsonObject.has("x")) {
                        sizeX = jsonObject.get("x").getAsInt();
                    }
                    if (jsonObject.has("y")) {
                        sizeY = jsonObject.get("y").getAsInt();
                    }
                    if (jsonObject.has("square")) {
                        sizeSquare = jsonObject.get("square").getAsInt();
                    }
                    if (sizeSquare == 0 && (sizeX == 0 || sizeY == 0)) {
                        Paintings.LOG.error("Tried loading a painting where one of the sides was 0 ! ");
                        Paintings.LOG.error("Painting name is : " + textureName);
                        Paintings.LOG.error("Skipping...");
                        continue;
                    }
                    if (sizeSquare % 16 != 0 && (sizeX % 16 != 0 || sizeY % 16 != 0)) {
                        Paintings.LOG.error("Tried loading a painting with a size that is not a multiple of 16 !! ");
                        Paintings.LOG.error("Painting name is : " + textureName);
                        Paintings.LOG.error("Skipping...");
                        continue;
                    }
                    PaintingEntry entry = new PaintingEntry(textureName, sizeX, sizeY, sizeSquare);
                    Paintings.LOG.info(String.format("Loaded json painting %s , %d x %d", entry.getRefName(), entry.getSizeX(), entry.getSizeY()));
                    addedPaintings.add(entry);
                }
                ((InputStream)stream).close();
            }
        }
        catch (IOException e) {
            Paintings.LOG.warn("************************************");
            Paintings.LOG.warn("!*!*!*!*!");
            Paintings.LOG.warn("No Painting Packs Detected. You will not be able to use ");
            Paintings.LOG.warn("the Paintings ++ Mod correctly.");
            Paintings.LOG.warn("Make sure to select or set some in the resourcepack gui !");
            Paintings.LOG.warn("!*!*!*!*!");
            Paintings.LOG.warn("************************************");
            e.printStackTrace();
        }
    }

    public static void registerToMinecraft(RegistryEvent.Register<PaintingType> event) {
        if (ConfigData.use_vanilla_only) {
            Paintings.LOG.info("Skipped registering any Paintings! Vanilla only will be used. This has been enforced by config");
            return;
        }
        for (PaintingEntry entry : addedPaintings) {
            PaintingType painting = (PaintingType)new PaintingType(entry.getSizeX(), entry.getSizeY()).setRegistryName("paintings", entry.getRefName());
            event.getRegistry().register((IForgeRegistryEntry)painting);
            Paintings.LOG.info("registered painting " + painting);
        }
    }
}

