/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.packet.client;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.packet.IPacketBase;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.util.ClientReferences;

public class CPacketPainting
implements IPacketBase {
    private int entityID;
    private String[] resLocNames;

    public CPacketPainting() {
    }

    public CPacketPainting(PaintingEntity painting, ResourceLocation[] resLocs) {
        this.entityID = painting.func_145782_y();
        this.resLocNames = new String[resLocs.length];
        int index = 0;
        for (ResourceLocation resLoc : resLocs) {
            this.resLocNames[index++] = resLoc.toString();
        }
    }

    public CPacketPainting(PacketBuffer buf) {
        this.decode(buf);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.resLocNames.length);
        for (String path : this.resLocNames) {
            buf.func_180714_a(path);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.entityID = buf.readInt();
        this.resLocNames = new String[buf.readInt()];
        for (int i = 0; i < this.resLocNames.length; ++i) {
            this.resLocNames[i] = buf.func_218666_n();
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (this.resLocNames.length == 1) {
                Entity entity = ClientReferences.getClientPlayer().field_70170_p.func_73045_a(this.entityID);
                if (entity instanceof PaintingEntity) {
                    PaintingEntity painting = (PaintingEntity)entity;
                    PaintingType type = (PaintingType)ForgeRegistries.PAINTING_TYPES.getValue(new ResourceLocation(this.resLocNames[0]));
                    Paintings.utility.setArt(painting, type);
                    Paintings.utility.updatePaintingBoundingBox((HangingEntity)painting);
                }
            } else {
                PaintingType[] types = new PaintingType[this.resLocNames.length];
                int dex = 0;
                for (String path : this.resLocNames) {
                    types[dex++] = (PaintingType)ForgeRegistries.PAINTING_TYPES.getValue(new ResourceLocation(path));
                }
                ClientReferences.openPaintingScreen(types, this.entityID);
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void encrypt(int id) {
        NetworkHandler.NETWORK.registerMessage(id, CPacketPainting.class, CPacketPainting::encode, CPacketPainting::new, CPacketPainting::handle);
    }
}

