/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.opengl.GL11;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.packet.NetworkHandler;
import subaraki.paintings.packet.server.SPacketPainting;

public class PaintingScreen
extends Screen {
    final int START_X = 10;
    final int START_Y = 30;
    final int GAP = 5;
    private PaintingType[] resLocs;
    private final int entityID;
    private int scrollbarscroll = 0;

    public PaintingScreen(PaintingType[] resLocs, int entityID) {
        super((ITextComponent)new TranslationTextComponent("select.a.painting", new Object[0]));
        this.resLocs = resLocs;
        this.entityID = entityID;
    }

    protected void init() {
        super.init();
        this.addButtons();
        this.scrollbarscroll = 0;
    }

    private void addButtons() {
        int END_X = this.width - 30;
        int prevHeight = this.resLocs[0].func_200832_c();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (PaintingType type : this.resLocs) {
            if (posx + type.func_200834_b() > END_X || prevHeight > type.func_200832_c()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = type.func_200832_c();
            }
            this.addButton((Widget)new PaintingButton(posx, posy, type.func_200834_b(), type.func_200832_c(), "", Button2 -> {
                NetworkHandler.NETWORK.sendToServer((Object)new SPacketPainting(type, this.entityID));
                this.onClose();
            }, type));
            posx += 5 + type.func_200834_b();
            ++index;
        }
        this.centerRow(rowstart, this.buttons.size() - 1);
    }

    private void centerRow(int start, int end) {
        int left = ((Widget)this.buttons.get((int)start)).x;
        int right = ((Widget)this.buttons.get((int)end)).x + ((Widget)this.buttons.get(end)).getWidth();
        int correction = (this.width - 20 - (right - left)) / 2;
        for (int i = start; i <= end; ++i) {
            Widget widget = (Widget)this.buttons.get(i);
            if (!(widget instanceof PaintingButton)) continue;
            ((PaintingButton)widget).shiftX(correction);
        }
    }

    public void render(int mouseX, int mouseY, float p_render_3_) {
        this.renderBackground();
        PaintingScreen.fill((int)10, (int)30, (int)(this.width - 10), (int)(this.height - 30), (int)0x44444444);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MainWindow window = this.minecraft.field_195558_d;
        int scale = (int)window.func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(10 * scale), (int)(30 * scale), (int)(this.width * scale), (int)((this.height - 60) * scale));
        super.render(mouseX, mouseY, p_render_3_);
        GL11.glDisable((int)3089);
        if (!this.buttons.isEmpty()) {
            this.drawFakeScrollBar();
        }
        String text = this.title.func_150254_d();
        this.drawCenteredString(this.font, text, this.width / 2, 15, 0xFFFFFF);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawToolTips(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseScroll) {
        Widget last = (Widget)this.buttons.get(this.buttons.size() - 1);
        Widget first = (Widget)this.buttons.get(0);
        int forsee_bottom_limit = (int)((double)(last.y + last.getHeight()) + mouseScroll * 16.0);
        int bottom_limit = this.height - 30 - last.getHeight();
        int forsee_top_limit = (int)((double)first.y + mouseScroll * 16.0);
        int top_limit = 35;
        if (mouseScroll < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.mouseScrolled(mouseX, mouseY, mouseScroll);
        }
        if (mouseScroll > 0.0 && forsee_top_limit > top_limit) {
            return super.mouseScrolled(mouseX, mouseY, mouseScroll);
        }
        this.move(mouseScroll);
        return super.mouseScrolled(mouseX, mouseY, mouseScroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        amountY *= -1.0;
        Widget last = (Widget)this.buttons.get(this.buttons.size() - 1);
        Widget first = (Widget)this.buttons.get(0);
        int forsee_bottom_limit = (int)((double)(last.y + last.getHeight()) + (amountY /= 2.0) * 16.0);
        int bottom_limit = this.height - 30 - last.getHeight();
        int forsee_top_limit = (int)((double)first.y + amountY * 16.0);
        int top_limit = 35;
        if (amountY < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.mouseDragged(mouseX, mouseY, buttonID, amountX, amountY);
        }
        if (amountY > 0.0 && forsee_top_limit > top_limit) {
            return super.mouseDragged(mouseX, mouseY, buttonID, amountX, amountY);
        }
        this.move(amountY);
        return super.mouseDragged(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void move(double scroll) {
        this.scrollbarscroll = (int)((double)this.scrollbarscroll - scroll * 16.0);
        for (Widget button : this.buttons) {
            button.y = (int)((double)button.y + scroll * 16.0);
        }
    }

    private void drawToolTips(int mouseX, int mouseY) {
        if (!ConfigData.show_painting_size) {
            return;
        }
        for (Widget guiButton : this.buttons) {
            PaintingButton button;
            if (!(guiButton instanceof PaintingButton) || !(button = (PaintingButton)guiButton).isMouseOver(mouseX, mouseY)) continue;
            StringTextComponent text = new StringTextComponent(button.getWidth() / 16 + "x" + button.getHeight() / 16);
            HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)text);
            Style style = new Style().func_150209_a(hover);
            this.renderComponentHoverEffect(hover.func_150702_b().func_150255_a(style), this.width / 2 - this.font.func_78256_a(text.func_150261_e()) - 4, this.height - 7);
        }
    }

    private void drawFakeScrollBar() {
        int top = ((Widget)this.buttons.get((int)0)).y;
        float containerSize = this.height - 60;
        int bot = ((Widget)this.buttons.get((int)(this.buttons.size() - 1))).y + ((Widget)this.buttons.get(this.buttons.size() - 1)).getHeight();
        float totalSize = bot - top + 5;
        float percent = containerSize / totalSize * 100.0f;
        if (percent < 100.0f) {
            float sizeBar = containerSize / 100.0f * percent;
            float relativeScroll = (float)this.scrollbarscroll / 100.0f * percent;
            this.fillGradient(this.width - 10, 30, this.width, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
            this.fillGradient(this.width - 10, 30 + (int)relativeScroll, this.width, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
        }
    }
}

