/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.block.CabinetBlock;
import com.mrcrayfish.furniture.block.CrateBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.inventory.container.CrateContainer;
import com.mrcrayfish.furniture.tileentity.BasicLootTileEntity;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CrateTileEntity
extends BasicLootTileEntity {
    private UUID ownerUuid;
    private boolean locked;
    private int playerCount;

    public CrateTileEntity() {
        super(ModTileEntities.CRATE);
    }

    @Override
    public int func_70302_i_() {
        return 27;
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cfm.crate", new Object[0]);
    }

    @Override
    protected Container func_213906_a(int windowId, PlayerInventory playerInventory) {
        if (this.locked && !this.ownerUuid.equals(playerInventory.field_70458_d.func_110124_au())) {
            playerInventory.field_70458_d.func_146105_b((ITextComponent)new TranslationTextComponent("container.isLocked", new Object[]{this.func_145748_c_()}), true);
            playerInventory.field_70458_d.func_213823_a(SoundEvents.field_187654_U, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return null;
        }
        return new CrateContainer(windowId, playerInventory, this, this.locked);
    }

    public UUID getOwner() {
        return this.ownerUuid;
    }

    public void setOwner(UUID uuid) {
        this.ownerUuid = uuid;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        TileEntityUtil.sendUpdatePacket((TileEntity)this);
    }

    public void func_174889_b(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            if (this.playerCount < 0) {
                this.playerCount = 0;
            }
            ++this.playerCount;
            BlockState blockState = this.func_195044_w();
            boolean open = (Boolean)blockState.func_177229_b((IProperty)CrateBlock.OPEN);
            if (!open) {
                this.playLidSound(blockState, ModSounds.BLOCK_CABINET_OPEN);
                this.setLidState(blockState, true);
            }
            this.scheduleTick();
        }
    }

    public void func_174886_c(PlayerEntity playerEntity) {
        if (!playerEntity.func_175149_v()) {
            --this.playerCount;
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void onScheduledTick() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        World world = this.func_145831_w();
        if (world != null) {
            this.updatePlayerCount(world, (IInventory)this, x, y, z);
            if (this.playerCount > 0) {
                this.scheduleTick();
            } else {
                BlockState blockState = this.func_195044_w();
                if (!(blockState.func_177230_c() instanceof CrateBlock)) {
                    this.func_145843_s();
                    return;
                }
                boolean open = (Boolean)blockState.func_177229_b((IProperty)CrateBlock.OPEN);
                if (open) {
                    this.playLidSound(blockState, ModSounds.BLOCK_CABINET_CLOSE);
                    this.setLidState(blockState, false);
                }
            }
        }
    }

    private void updatePlayerCount(World world, IInventory inventory, int x, int y, int z) {
        this.playerCount = 0;
        for (PlayerEntity playerEntity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            CrateTileEntity crateInventory;
            if (!(playerEntity.field_71070_bA instanceof CrateContainer) || inventory != (crateInventory = ((CrateContainer)playerEntity.field_71070_bA).getCrateTileEntity())) continue;
            ++this.playerCount;
        }
    }

    public void removeUnauthorisedPlayers() {
        if (this.locked) {
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            for (PlayerEntity playerEntity : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                CrateTileEntity crateInventory;
                if (!(playerEntity.field_71070_bA instanceof CrateContainer) || this != (crateInventory = ((CrateContainer)playerEntity.field_71070_bA).getCrateTileEntity()) || playerEntity.func_110124_au().equals(this.ownerUuid)) continue;
                playerEntity.func_71053_j();
            }
        }
    }

    private void playLidSound(BlockState blockState, SoundEvent soundEvent) {
        Vec3i directionVec = ((Direction)blockState.func_177229_b((IProperty)CabinetBlock.DIRECTION)).func_176730_m();
        double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)directionVec.func_177958_n() / 2.0;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)directionVec.func_177956_o() / 2.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)directionVec.func_177952_p() / 2.0;
        World world = this.func_145831_w();
        if (world != null) {
            world.func_184148_a(null, x, y, z, soundEvent, SoundCategory.BLOCKS, 0.75f, world.field_73012_v.nextFloat() * 0.1f + 0.7f);
        }
    }

    private void setLidState(BlockState blockState, boolean open) {
        World world = this.func_145831_w();
        if (world != null) {
            world.func_180501_a(this.func_174877_v(), (BlockState)blockState.func_206870_a((IProperty)CrateBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readData(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeData(compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.writeData(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.readData(compound);
    }

    private void readData(CompoundNBT compound) {
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUuid = compound.func_186857_a("OwnerUUID");
        }
        if (compound.func_150297_b("Locked", 1)) {
            this.locked = compound.func_74767_n("Locked");
        }
    }

    private CompoundNBT writeData(CompoundNBT compound) {
        if (this.ownerUuid != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUuid);
        }
        compound.func_74757_a("Locked", this.locked);
        return compound;
    }

    @Override
    public boolean func_180462_a(int i, ItemStack itemStack, @Nullable Direction direction) {
        return !this.locked;
    }

    @Override
    public boolean func_180461_b(int i, ItemStack itemStack, Direction direction) {
        return !this.locked;
    }
}

