/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.common.mail;

import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.MailBox;
import com.mrcrayfish.furniture.tileentity.MailBoxTileEntity;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="cfm")
public class PostOffice
extends WorldSavedData {
    private static final String DATA_NAME = "cfm_post_office";
    private Map<UUID, Map<UUID, MailBox>> playerMailboxMap = new HashMap<UUID, Map<UUID, MailBox>>();

    public PostOffice() {
        super(DATA_NAME);
    }

    public PostOffice(String name) {
        super(name);
    }

    public void func_76184_a(CompoundNBT compound) {
        this.playerMailboxMap.clear();
        if (compound.func_150297_b("PlayerMailBoxes", 9)) {
            ListNBT playerMailBoxesList = compound.func_150295_c("PlayerMailBoxes", 10);
            playerMailBoxesList.forEach(nbt -> {
                CompoundNBT playerMailBoxesCompound = (CompoundNBT)nbt;
                UUID playerId = playerMailBoxesCompound.func_186857_a("PlayerUUID");
                if (playerMailBoxesCompound.func_150297_b("MailBoxes", 9)) {
                    HashMap mailBoxMap = new HashMap();
                    ListNBT mailBoxList = playerMailBoxesCompound.func_150295_c("MailBoxes", 10);
                    mailBoxList.forEach(nbt2 -> {
                        CompoundNBT mailBoxCompound = (CompoundNBT)nbt2;
                        UUID mailBoxId = mailBoxCompound.func_186857_a("MailBoxUUID");
                        MailBox mailBox = new MailBox(mailBoxCompound.func_74775_l("MailBox"));
                        mailBoxMap.put(mailBoxId, mailBox);
                    });
                    this.playerMailboxMap.put(playerId, mailBoxMap);
                }
            });
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT playerMailBoxesList = new ListNBT();
        this.playerMailboxMap.forEach((playerId, mailStorage) -> {
            if (!mailStorage.isEmpty()) {
                CompoundNBT playerMailBoxesCompound = new CompoundNBT();
                playerMailBoxesCompound.func_186854_a("PlayerUUID", playerId);
                ListNBT mailBoxList = new ListNBT();
                mailStorage.forEach((mailBoxId, mailBox) -> {
                    CompoundNBT mailBoxCompound = new CompoundNBT();
                    mailBoxCompound.func_186854_a("MailBoxUUID", mailBoxId);
                    mailBoxCompound.func_218657_a("MailBox", (INBT)mailBox.serializeNBT());
                    mailBoxList.add((Object)mailBoxCompound);
                });
                playerMailBoxesCompound.func_218657_a("MailBoxes", (INBT)mailBoxList);
                playerMailBoxesList.add((Object)playerMailBoxesCompound);
            }
        });
        compound.func_218657_a("PlayerMailBoxes", (INBT)playerMailBoxesList);
        return compound;
    }

    public static void registerMailBox(ServerPlayerEntity playerEntity, UUID mailBoxId, String name, BlockPos pos) {
        PostOffice office = PostOffice.get(playerEntity.field_71133_b);
        Map mailBoxMap = office.playerMailboxMap.computeIfAbsent(playerEntity.func_110124_au(), uuid -> new HashMap());
        mailBoxMap.put(mailBoxId, new MailBox(mailBoxId, name, playerEntity.func_110124_au(), playerEntity.func_200200_C_().getString(), pos, playerEntity.field_71093_bK));
        office.func_76185_a();
    }

    public static void unregisterMailBox(UUID playerId, UUID mailBoxId) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PostOffice office = PostOffice.get(server);
            Map mailBoxMap = office.playerMailboxMap.computeIfAbsent(playerId, uuid -> new HashMap());
            mailBoxMap.remove(mailBoxId);
            office.func_76185_a();
        }
    }

    public static List<MailBox> getMailBoxes(ServerPlayerEntity playerEntity) {
        PostOffice office = PostOffice.get(playerEntity.field_71133_b);
        return office.playerMailboxMap.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public static boolean sendMailToPlayer(UUID playerId, UUID mailBoxId, Mail mail) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PostOffice office = PostOffice.get(server);
            Map mailBoxMap = office.playerMailboxMap.computeIfAbsent(playerId, uuid -> new HashMap());
            if (mailBoxMap.containsKey(mailBoxId)) {
                ((MailBox)mailBoxMap.get(mailBoxId)).addMail(mail);
                office.func_76185_a();
                return true;
            }
        }
        return false;
    }

    public static Supplier<Mail> getMailForPlayerMailBox(UUID playerId, UUID mailBoxId) {
        return () -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                MailBox mailBox;
                List<Mail> mailStorage;
                Map<UUID, MailBox> mailBoxMap;
                PostOffice office = PostOffice.get(server);
                if (office.playerMailboxMap.containsKey(playerId) && (mailBoxMap = office.playerMailboxMap.get(playerId)).containsKey(mailBoxId) && !(mailStorage = (mailBox = mailBoxMap.get(mailBoxId)).getMailStorage()).isEmpty()) {
                    office.func_76185_a();
                    return mailStorage.remove(0);
                }
            }
            return null;
        };
    }

    public static boolean setMailBoxName(UUID playerId, UUID mailBoxId, String name) {
        if ((name = name.trim()).trim().isEmpty()) {
            return false;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            Map<UUID, MailBox> mailBoxMap;
            PostOffice office = PostOffice.get(server);
            if (office.playerMailboxMap.containsKey(playerId) && (mailBoxMap = office.playerMailboxMap.get(playerId)).containsKey(mailBoxId)) {
                MailBox mailBox = mailBoxMap.get(mailBoxId);
                mailBox.setName(name);
                ServerWorld world = server.func_71218_a(mailBox.getDimensionType());
                TileEntity tileEntity = world.func_175625_s(mailBox.getPos());
                if (tileEntity instanceof MailBoxTileEntity) {
                    ((MailBoxTileEntity)tileEntity).setMailBoxName(name);
                    TileEntityUtil.sendUpdatePacket(tileEntity);
                    return true;
                }
            }
        }
        return false;
    }

    private static PostOffice get(MinecraftServer server) {
        ServerWorld world = server.func_71218_a(DimensionType.field_223227_a_);
        return (PostOffice)world.func_217481_x().func_215752_a(PostOffice::new, DATA_NAME);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.func_71259_af() % 1200 == 0) {
            PostOffice office = PostOffice.get(server);
            office.playerMailboxMap.values().forEach(uuidMailBoxMap -> uuidMailBoxMap.values().removeIf(mailBox -> {
                BlockPos pos = mailBox.getPos();
                ServerWorld world = server.func_71218_a(mailBox.getDimensionType());
                if (world.isAreaLoaded(pos, 0)) {
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof MailBoxTileEntity) {
                        MailBoxTileEntity mailBoxTileEntity = (MailBoxTileEntity)tileEntity;
                        return mailBoxTileEntity.getId() == null || !Objects.equals(mailBoxTileEntity.getId(), mailBox.getId());
                    }
                    return true;
                }
                return false;
            }));
        }
    }
}

