/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.FurnitureMod;
import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class HedgeBlock
extends FurnitureWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final ImmutableMap<BlockState, VoxelShape> COLLISION_SHAPES;

    public HedgeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), false);
        this.COLLISION_SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), true);
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states, boolean collision) {
        VoxelShape POST = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape[] SIDE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.func_177229_b((IProperty)NORTH);
            boolean east = (Boolean)state.func_177229_b((IProperty)EAST);
            boolean south = (Boolean)state.func_177229_b((IProperty)SOUTH);
            boolean west = (Boolean)state.func_177229_b((IProperty)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(this.applyCollision(POST, collision));
            if (north) {
                shapes.add(this.applyCollision(SIDE[Direction.NORTH.func_176736_b()], collision));
            }
            if (east) {
                shapes.add(this.applyCollision(SIDE[Direction.EAST.func_176736_b()], collision));
            }
            if (south) {
                shapes.add(this.applyCollision(SIDE[Direction.SOUTH.func_176736_b()], collision));
            }
            if (west) {
                shapes.add(this.applyCollision(SIDE[Direction.WEST.func_176736_b()], collision));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    private VoxelShape applyCollision(VoxelShape shape, boolean collision) {
        if (collision) {
            shape = VoxelShapeHelper.setMaxHeight(shape, 1.5);
            shape = VoxelShapeHelper.limitHorizontal(shape);
        }
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.COLLISION_SHAPES.get((Object)state);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getHedgeState(state, world, pos);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getHedgeState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState getHedgeState(BlockState state, IWorld world, BlockPos pos) {
        boolean north = this.canConnectToBlock(state, world, pos, Direction.NORTH);
        boolean east = this.canConnectToBlock(state, world, pos, Direction.EAST);
        boolean south = this.canConnectToBlock(state, world, pos, Direction.SOUTH);
        boolean west = this.canConnectToBlock(state, world, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean canConnectToBlock(BlockState state, IWorld world, BlockPos pos, Direction direction) {
        BlockPos offsetPos = pos.func_177972_a(direction);
        BlockState offsetState = world.func_180495_p(offsetPos);
        if (offsetState.func_177230_c() == this) {
            return true;
        }
        return offsetState.func_224755_d((IBlockReader)world, offsetPos, direction.func_176734_d());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{NORTH});
        builder.func_206894_a(new IProperty[]{EAST});
        builder.func_206894_a(new IProperty[]{SOUTH});
        builder.func_206894_a(new IProperty[]{WEST});
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return FurnitureMod.PROXY.useFancyGraphics() ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public boolean func_220060_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    @Deprecated
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }
}

