/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.item;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.client.render.model.CrownModel;
import top.theillusivec4.curios.common.capability.CapCurioItem;

public class CrownItem
extends Item {
    private static final ResourceLocation CROWN_TEXTURE = new ResourceLocation("curios", "textures/entity/crown.png");

    public CrownItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1).func_200915_b(2000));
        this.setRegistryName("curios", "crown");
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT unused) {
        return CapCurioItem.createProvider(new ICurio(){
            private Object model;

            @Override
            public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
                if (!livingEntity.func_130014_f_().field_72995_K && livingEntity.field_70173_aa % 20 == 0) {
                    livingEntity.func_195064_c(new EffectInstance(Effects.field_76439_r, 300, 44, true, true));
                    stack.func_222118_a(1, livingEntity, damager -> CuriosAPI.onBrokenCurio(identifier, index, damager));
                }
            }

            @Override
            public void onUnequipped(String identifier, LivingEntity livingEntity) {
                EffectInstance effect = livingEntity.func_70660_b(Effects.field_76439_r);
                if (effect != null && effect.func_76458_c() == 44) {
                    livingEntity.func_195063_d(Effects.field_76439_r);
                }
            }

            @Override
            public boolean hasRender(String identifier, LivingEntity livingEntity) {
                return true;
            }

            @Override
            public void doRender(String identifier, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CROWN_TEXTURE);
                if (!(this.model instanceof CrownModel)) {
                    this.model = new CrownModel();
                }
                CrownModel crown = (CrownModel)((Object)this.model);
                ICurio.RenderHelper.followHeadRotations(livingEntity, crown.crown);
                crown.func_78088_a((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        });
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

