/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.event.LivingCurioChangeEvent;
import top.theillusivec4.curios.api.event.LivingCurioDropRulesEvent;
import top.theillusivec4.curios.api.event.LivingCurioDropsEvent;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.capability.CapCurioInventory;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncContents;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncContentsWithTag;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncMap;

public class EventHandlerCurios {
    @SubscribeEvent
    public void onCapabilitiesEntity(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity) {
            evt.addCapability(CuriosCapability.ID_INVENTORY, CapCurioInventory.createProvider((LivingEntity)((PlayerEntity)evt.getObject())));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)evt.getEntity();
            CuriosAPI.getCuriosHandler(livingBase).ifPresent(handler -> {
                handler.dropInvalidCache();
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity mp = (ServerPlayerEntity)entity;
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> mp), (Object)new SPacketSyncMap(mp.func_145782_y(), handler.getCurioMap()));
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking evt) {
        Entity target = evt.getTarget();
        PlayerEntity player = evt.getPlayer();
        if (player instanceof ServerPlayerEntity && target instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)target;
            CuriosAPI.getCuriosHandler(livingBase).ifPresent(handler -> NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SPacketSyncMap(target.func_145782_y(), handler.getCurioMap())));
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        PlayerEntity player = evt.getPlayer();
        PlayerEntity oldPlayer = evt.getOriginal();
        oldPlayer.revive();
        LazyOptional<ICurioItemHandler> oldHandler = CuriosAPI.getCuriosHandler((LivingEntity)oldPlayer);
        LazyOptional<ICurioItemHandler> newHandler = CuriosAPI.getCuriosHandler((LivingEntity)player);
        oldHandler.ifPresent(oldCurios -> newHandler.ifPresent(newCurios -> {
            newCurios.setCurioMap(new TreeMap<String, CurioStackHandler>(oldCurios.getCurioMap()));
            oldCurios.getCurioMap().forEach((identifier, stackHandler) -> {
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    CuriosAPI.getCurio(stack).ifPresent(curio -> {
                        player.func_110140_aT().func_111147_b(curio.getAttributeModifiers((String)identifier));
                        curio.onEquipped((String)identifier, (LivingEntity)player);
                    });
                }
            });
        }));
    }

    @SubscribeEvent
    public void onPlayerDrops(LivingDropsEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.func_175149_v()) {
            CuriosAPI.getCuriosHandler(livingEntity).ifPresent(handler -> {
                Collection drops = evt.getDrops();
                ArrayList<ItemEntity> curioDrops = new ArrayList<ItemEntity>();
                SortedMap<String, CurioStackHandler> curioMap = handler.getCurioMap();
                LivingCurioDropRulesEvent dropRulesEvent = new LivingCurioDropRulesEvent(livingEntity, (ICurioItemHandler)handler, evt.getSource(), evt.getLootingLevel(), evt.isRecentlyHit());
                MinecraftForge.EVENT_BUS.post((Event)dropRulesEvent);
                ImmutableList<Tuple<Predicate<ItemStack>, ICurio.DropRule>> dropRules = dropRulesEvent.getOverrides();
                boolean keepInventory = livingEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
                for (String identifier : curioMap.keySet()) {
                    ItemStackHandler stacks = (ItemStackHandler)curioMap.get(identifier);
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ICurio.DropRule dropRule;
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        ICurio.DropRule dropRuleOverride = null;
                        for (Tuple override : dropRules) {
                            if (!((Predicate)override.func_76341_a()).test(stack)) continue;
                            dropRuleOverride = (ICurio.DropRule)((Object)((Object)override.func_76340_b()));
                        }
                        ICurio.DropRule dropRule2 = dropRule = dropRuleOverride != null ? dropRuleOverride : (ICurio.DropRule)((Object)((Object)CuriosAPI.getCurio(stack).map(curio -> curio.getDropRule(livingEntity)).orElse((Object)ICurio.DropRule.DEFAULT)));
                        if (dropRule == ICurio.DropRule.DEFAULT && keepInventory || dropRule == ICurio.DropRule.ALWAYS_KEEP) continue;
                        if (!EnchantmentHelper.func_190939_c((ItemStack)stack) && dropRule != ICurio.DropRule.DESTROY) {
                            curioDrops.add(this.getDroppedItem(stack, livingEntity));
                        }
                        stacks.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
                if (!MinecraftForge.EVENT_BUS.post((Event)new LivingCurioDropsEvent(livingEntity, (ICurioItemHandler)handler, evt.getSource(), (Collection<ItemEntity>)curioDrops, evt.getLootingLevel(), evt.isRecentlyHit()))) {
                    drops.addAll(curioDrops);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerXPPickUp(PlayerPickupXpEvent evt) {
        PlayerEntity player = evt.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                SortedMap<String, CurioStackHandler> curioMap = handler.getCurioMap();
                for (String identifier : curioMap.keySet()) {
                    ItemStackHandler stacks = (ItemStackHandler)curioMap.get(identifier);
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        ItemStack stack = stacks.getStackInSlot(i);
                        if (stack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0 || !stack.func_77951_h()) continue;
                        evt.setCanceled(true);
                        ExperienceOrbEntity orb = evt.getOrb();
                        player.field_71090_bL = 2;
                        player.func_71001_a((Entity)orb, 1);
                        int toRepair = Math.min(orb.field_70530_e * 2, stack.func_77952_i());
                        orb.field_70530_e -= toRepair / 2;
                        stack.func_196085_b(stack.func_77952_i() - toRepair);
                        if (orb.field_70530_e > 0) {
                            player.func_195068_e(orb.field_70530_e);
                        }
                        orb.func_70106_y();
                        return;
                    }
                }
            });
        }
    }

    private ItemEntity getDroppedItem(ItemStack droppedItem, LivingEntity livingEntity) {
        double d0 = livingEntity.field_70163_u - (double)0.3f + (double)livingEntity.func_70047_e();
        ItemEntity entityitem = new ItemEntity(livingEntity.field_70170_p, livingEntity.field_70165_t, d0, livingEntity.field_70161_v, droppedItem);
        entityitem.func_174867_a(40);
        float f = livingEntity.field_70170_p.field_73012_v.nextFloat() * 0.5f;
        float f1 = livingEntity.field_70170_p.field_73012_v.nextFloat() * ((float)Math.PI * 2);
        entityitem.func_213293_j((double)(-MathHelper.func_76126_a((float)f1) * f), (double)0.2f, (double)(MathHelper.func_76134_b((float)f1) * f));
        return entityitem;
    }

    @SubscribeEvent
    public void onCurioRightClick(PlayerInteractEvent.RightClickItem evt) {
        PlayerEntity player = evt.getPlayer();
        ItemStack stack = evt.getItemStack();
        CuriosAPI.getCurio(stack).ifPresent(curio -> {
            if (curio.canRightClickEquip()) {
                CuriosAPI.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                    if (!player.field_70170_p.field_72995_K) {
                        SortedMap<String, CurioStackHandler> curios = handler.getCurioMap();
                        Set<String> tags = CuriosAPI.getCurioTags(stack.func_77973_b());
                        for (String id : tags) {
                            ItemStackHandler stackHandler;
                            if (!curio.canEquip(id, (LivingEntity)player) || (stackHandler = (ItemStackHandler)curios.get(id)) == null) continue;
                            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                                if (!stackHandler.getStackInSlot(i).func_190926_b()) continue;
                                stackHandler.setStackInSlot(i, stack.func_77946_l());
                                curio.playEquipSound((LivingEntity)player);
                                if (!player.func_184812_l_()) {
                                    int count = stack.func_190916_E();
                                    stack.func_190918_g(count);
                                }
                                evt.setCancellationResult(ActionResultType.SUCCESS);
                                evt.setCanceled(true);
                                return;
                            }
                        }
                    } else {
                        evt.setCancellationResult(ActionResultType.SUCCESS);
                        evt.setCanceled(true);
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void onCurioTick(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity entitylivingbase = evt.getEntityLiving();
        CuriosAPI.getCuriosHandler(entitylivingbase).ifPresent(handler -> {
            SortedMap<String, CurioStackHandler> curios = handler.getCurioMap();
            for (String identifier : curios.keySet()) {
                CurioStackHandler stackHandler = (CurioStackHandler)((Object)((Object)curios.get(identifier)));
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack prevStack;
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    stack.func_77945_a(entitylivingbase.field_70170_p, (Entity)entitylivingbase, -1, false);
                    LazyOptional<ICurio> currentCurio = CuriosAPI.getCurio(stack);
                    int index = i;
                    currentCurio.ifPresent(curio -> curio.onCurioTick(identifier, index, entitylivingbase));
                    if (entitylivingbase.field_70170_p.field_72995_K || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(prevStack = stackHandler.getPreviousStackInSlot(i)))) continue;
                    LazyOptional<ICurio> prevCurio = CuriosAPI.getCurio(prevStack);
                    boolean shouldSync = !stack.equals(prevStack, true);
                    CompoundNBT syncTag = new CompoundNBT();
                    boolean currentSyncFlag = (Boolean)currentCurio.map(curio -> curio.shouldSyncToTracking(identifier, entitylivingbase)).orElse((Object)false);
                    boolean prevSyncFlag = (Boolean)prevCurio.map(curio -> curio.shouldSyncToTracking(identifier, entitylivingbase)).orElse((Object)false);
                    if (currentSyncFlag || prevSyncFlag || shouldSync) {
                        if (currentCurio.isPresent()) {
                            syncTag = (CompoundNBT)currentCurio.map(ICurio::getSyncTag).orElse((Object)syncTag);
                        }
                        if (!syncTag.isEmpty()) {
                            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entitylivingbase), (Object)new SPacketSyncContentsWithTag(entitylivingbase.func_145782_y(), identifier, i, stack, syncTag));
                        } else {
                            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entitylivingbase), (Object)new SPacketSyncContents(entitylivingbase.func_145782_y(), identifier, i, stack));
                        }
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new LivingCurioChangeEvent(entitylivingbase, identifier, i, prevStack, stack));
                    boolean changeEquipped = !ItemStack.func_185132_d((ItemStack)prevStack, (ItemStack)stack);
                    prevCurio.ifPresent(curio -> {
                        entitylivingbase.func_110140_aT().func_111148_a(curio.getAttributeModifiers(identifier));
                        if (changeEquipped) {
                            curio.onUnequipped(identifier, entitylivingbase);
                        }
                    });
                    currentCurio.ifPresent(curio -> {
                        entitylivingbase.func_110140_aT().func_111147_b(curio.getAttributeModifiers(identifier));
                        if (changeEquipped) {
                            curio.onEquipped(identifier, entitylivingbase);
                        }
                    });
                    stackHandler.setPreviousStackInSlot(i, stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l());
                }
            }
        });
    }
}

