/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class EventHandlerClient {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @SubscribeEvent
    public void onKeyInput(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (KeyRegistry.openCurios.func_151468_f() && mc.func_195544_aj()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketOpenCurios());
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        if (!stack.func_190926_b()) {
            Set<String> curioTags;
            ArrayList<String> slots;
            List tooltip = evt.getToolTip();
            CompoundNBT tag = stack.func_77978_p();
            int i = 0;
            if (tag != null && tag.func_150297_b("HideFlags", 99)) {
                i = tag.func_74762_e("HideFlags");
            }
            if (!(slots = new ArrayList<String>(curioTags = CuriosAPI.getCurioTags(stack.func_77973_b()))).isEmpty()) {
                ArrayList<ITextComponent> tagTooltips = new ArrayList<ITextComponent>();
                ITextComponent slotsTooltip = new TranslationTextComponent("curios.slot", new Object[0]).func_150258_a(": ").func_211708_a(TextFormatting.GOLD);
                for (int j = 0; j < slots.size(); ++j) {
                    String key = "curios.identifier." + (String)slots.get(j);
                    TranslationTextComponent type = new TranslationTextComponent(key, new Object[0]);
                    if (j < slots.size() - 1) {
                        type = type.func_150258_a(", ");
                    }
                    type = type.func_211708_a(TextFormatting.YELLOW);
                    slotsTooltip.func_150257_a((ITextComponent)type);
                }
                tagTooltips.add(slotsTooltip);
                CuriosAPI.getCurio(stack).ifPresent(curio -> {
                    List<ITextComponent> curioTagsTooltip = curio.getTagsTooltip(tagTooltips);
                    if (!curioTagsTooltip.isEmpty()) {
                        tooltip.addAll(1, curio.getTagsTooltip(tagTooltips));
                    }
                });
                if (!CuriosAPI.getCurio(stack).isPresent()) {
                    tooltip.addAll(1, tagTooltips);
                }
                int hideFlags = i;
                CuriosAPI.getCurio(stack).ifPresent(curio -> {
                    for (String identifier : slots) {
                        Multimap<String, AttributeModifier> multimap = curio.getAttributeModifiers(identifier);
                        if (multimap.isEmpty() || (hideFlags & 2) != 0) continue;
                        PlayerEntity player = evt.getEntityPlayer();
                        tooltip.add(new StringTextComponent(""));
                        tooltip.add(new TranslationTextComponent("curios.modifiers." + identifier, new Object[0]).func_211708_a(TextFormatting.GOLD));
                        for (Map.Entry entry : multimap.entries()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            double amount = attributemodifier.func_111164_d();
                            boolean flag = false;
                            if (player == null) continue;
                            if (attributemodifier.func_111167_a() == ATTACK_DAMAGE_MODIFIER) {
                                amount += player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                                amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
                                flag = true;
                            } else if (attributemodifier.func_111167_a() == ATTACK_SPEED_MODIFIER) {
                                amount += player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                                flag = true;
                            }
                            double d1 = attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? amount : amount * 100.0;
                            if (flag) {
                                tooltip.add(new StringTextComponent(" ").func_150257_a((ITextComponent)new TranslationTextComponent("attribute.modifier.equals." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)entry.getKey(), new Object[0])})).func_211708_a(TextFormatting.DARK_GREEN));
                                continue;
                            }
                            if (amount > 0.0) {
                                tooltip.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)entry.getKey(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                                continue;
                            }
                            if (!(amount < 0.0)) continue;
                            tooltip.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent("attribute.name." + (String)entry.getKey(), new Object[0])}).func_211708_a(TextFormatting.RED));
                        }
                    }
                });
            }
        }
    }
}

