/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.inventory;

import com.progwml6.ironchest.common.blocks.ChestType;
import com.progwml6.ironchest.common.inventory.ChestContainerType;
import com.progwml6.ironchest.common.inventory.DirtChestSlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChestContainer
extends Container {
    private final IInventory inventory;
    private final ChestType chestType;

    private ChestContainer(ContainerType<?> containerType, int windowId, PlayerInventory playerInventory) {
        this(containerType, windowId, playerInventory, (IInventory)new Inventory(ChestType.WOOD.size), ChestType.WOOD);
    }

    public static ChestContainer createIronContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.IRON_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.IRON.size), ChestType.IRON);
    }

    public static ChestContainer createIronContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.IRON_CHEST, windowId, playerInventory, inventory, ChestType.IRON);
    }

    public static ChestContainer createGoldContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.GOLD_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.GOLD.size), ChestType.GOLD);
    }

    public static ChestContainer createGoldContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.GOLD_CHEST, windowId, playerInventory, inventory, ChestType.GOLD);
    }

    public static ChestContainer createDiamondContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.DIAMOND_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.DIAMOND.size), ChestType.DIAMOND);
    }

    public static ChestContainer createDiamondContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.DIAMOND_CHEST, windowId, playerInventory, inventory, ChestType.DIAMOND);
    }

    public static ChestContainer createCrystalContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.CRYSTAL_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.CRYSTAL.size), ChestType.CRYSTAL);
    }

    public static ChestContainer createCrystalContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.CRYSTAL_CHEST, windowId, playerInventory, inventory, ChestType.CRYSTAL);
    }

    public static ChestContainer createCopperContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.COPPER_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.COPPER.size), ChestType.COPPER);
    }

    public static ChestContainer createCopperContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.COPPER_CHEST, windowId, playerInventory, inventory, ChestType.COPPER);
    }

    public static ChestContainer createSilverContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.SILVER_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.CRYSTAL.size), ChestType.SILVER);
    }

    public static ChestContainer createSilverContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.SILVER_CHEST, windowId, playerInventory, inventory, ChestType.SILVER);
    }

    public static ChestContainer createObsidianContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.OBSIDIAN_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.OBSIDIAN.size), ChestType.OBSIDIAN);
    }

    public static ChestContainer createObsidianContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.OBSIDIAN_CHEST, windowId, playerInventory, inventory, ChestType.OBSIDIAN);
    }

    public static ChestContainer createDirtContainer(int windowId, PlayerInventory playerInventory) {
        return new ChestContainer(ChestContainerType.DIRT_CHEST, windowId, playerInventory, (IInventory)new Inventory(ChestType.DIRTCHEST9000.size), ChestType.DIRTCHEST9000);
    }

    public static ChestContainer createDirtContainer(int windowId, PlayerInventory playerInventory, IInventory inventory) {
        return new ChestContainer(ChestContainerType.DIRT_CHEST, windowId, playerInventory, inventory, ChestType.DIRTCHEST9000);
    }

    public ChestContainer(ContainerType<?> containerType, int windowId, PlayerInventory playerInventory, IInventory inventory, ChestType chestType) {
        super(containerType, windowId);
        ChestContainer.func_216962_a((IInventory)inventory, (int)chestType.size);
        this.inventory = inventory;
        this.chestType = chestType;
        inventory.func_174889_b(playerInventory.field_70458_d);
        if (chestType == ChestType.DIRTCHEST9000) {
            this.func_75146_a(new DirtChestSlot(inventory, 0, 84, 44));
        } else {
            for (int chestRow = 0; chestRow < chestType.getRowCount(); ++chestRow) {
                for (int chestCol = 0; chestCol < chestType.rowLength; ++chestCol) {
                    this.func_75146_a(new Slot(inventory, chestCol + chestRow * chestType.rowLength, 12 + chestCol * 18, 18 + chestRow * 18));
                }
            }
        }
        int leftCol = (chestType.xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot((IInventory)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, chestType.ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, chestType.ySize - 24));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.chestType.size ? !this.func_75135_a(itemstack1, this.chestType.size, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.chestType.size, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChestType getChestType() {
        return this.chestType;
    }
}

