/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.renderer;

import com.google.common.primitives.SignedBytes;
import com.mojang.blaze3d.platform.GlStateManager;
import com.progwml6.ironchest.common.blocks.ChestBlock;
import com.progwml6.ironchest.common.blocks.ChestType;
import com.progwml6.ironchest.common.tileentity.CrystalChestTileEntity;
import com.progwml6.ironchest.common.tileentity.IronChestTileEntity;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IronChestTileEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final ChestModel chestModel = new ChestModel();
    private static ItemEntity customItem;
    private Random random = new Random();
    private ItemRenderer itemRenderer;
    private static float[][] shifts;

    public void func_199341_a(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        IronChestTileEntity tileEntity = (IronChestTileEntity)((Object)tileEntityIn);
        BlockState blockstate = tileEntity.func_145830_o() ? tileEntity.func_195044_w() : (BlockState)tileEntity.getBlockToUse().func_176223_P().func_206870_a((IProperty)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chestType = ChestType.IRON;
        ChestType actualType = ChestBlock.getTypeFromBlock(blockstate.func_177230_c());
        if (actualType != null) {
            chestType = actualType;
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.func_147499_a(new ResourceLocation("ironchest", "textures/model/" + chestType.modelTexture));
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.pushMatrix();
        if (chestType == ChestType.CRYSTAL) {
            GlStateManager.disableCull();
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        float f = ((Direction)blockstate.func_177229_b((IProperty)ChestBlock.FACING)).func_185119_l();
        if ((double)Math.abs(f) > 1.0E-5) {
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        if (chestType.isTransparent()) {
            GlStateManager.scalef((float)1.0f, (float)0.99f, (float)1.0f);
        }
        this.rotateChestLid(tileEntityIn, partialTicks, this.chestModel);
        this.chestModel.func_78231_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        if (chestType == ChestType.CRYSTAL) {
            GlStateManager.enableCull();
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
        if (this.field_147501_a.field_217666_g != null && chestType.isTransparent() && tileEntity.func_145835_a(this.field_147501_a.field_217666_g.func_216785_c().field_72450_a, this.field_147501_a.field_217666_g.func_216785_c().field_72448_b, this.field_147501_a.field_217666_g.func_216785_c().field_72449_c) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
            if (((ItemStack)((CrystalChestTileEntity)tileEntity).getTopItems().get(1)).func_190926_b()) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
            if (customItem == null) {
                customItem = new ItemEntity(EntityType.field_200765_E, this.func_178459_a());
            }
            for (ItemStack item : ((CrystalChestTileEntity)tileEntity).getTopItems()) {
                if (shift > shifts.length || shift > 8) break;
                if (item.func_190926_b()) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.rotatef((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.scalef((float)blockScale, (float)blockScale, (float)blockScale);
                customItem.func_92058_a(item);
                if (this.itemRenderer == null) {
                    this.itemRenderer = new ItemRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

                        public int func_177078_a(ItemStack stack) {
                            return SignedBytes.saturatedCast((long)(Math.min(stack.func_190916_E() / 32, 15) + 1));
                        }

                        public boolean shouldBob() {
                            return false;
                        }

                        public boolean shouldSpreadItems() {
                            return true;
                        }
                    };
                }
                this.itemRenderer.func_76986_a(customItem, 0.0, 0.0, 0.0, 0.0f, partialTicks);
                GlStateManager.popMatrix();
            }
            GlStateManager.popMatrix();
        }
    }

    private void rotateChestLid(T tileEntity, float partialTicks, ChestModel chestModel) {
        float f = ((IChestLid)tileEntity).func_195480_a(partialTicks);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        chestModel.func_205058_b().field_78795_f = -(f * 1.5707964f);
    }

    static {
        shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    }
}

