/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.client.model.layer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class CustomHeldItemLayer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public CustomHeldItemLayer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public void render(AbstractClientPlayerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack rightStack;
        boolean isRightHanded = entity.func_184591_cq() == HandSide.RIGHT;
        ItemStack leftStack = isRightHanded ? entity.func_184592_cb() : entity.func_184614_ca();
        ItemStack itemStack = rightStack = isRightHanded ? entity.func_184614_ca() : entity.func_184592_cb();
        if (!leftStack.func_190926_b() || !rightStack.func_190926_b()) {
            GlStateManager.pushMatrix();
            if (((PlayerModel)this.func_215332_c()).field_217114_e) {
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            this.renderHeldItem((LivingEntity)entity, rightStack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, partialTicks);
            this.renderHeldItem((LivingEntity)entity, leftStack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, partialTicks);
            GlStateManager.popMatrix();
        }
    }

    private void renderHeldItem(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide handSide, float partialTicks) {
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            if (entity.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.translateToHand(handSide);
            GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            boolean isLeftHanded = handSide == HandSide.LEFT;
            GlStateManager.translatef((float)((float)(isLeftHanded ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.625f);
            if (this.isArmVisible(handSide) && !MinecraftForge.EVENT_BUS.post((Event)new RenderItemEvent.Held.Pre(entity, stack, transformType, handSide, partialTicks))) {
                Minecraft.func_71410_x().func_175597_ag().func_187462_a(entity, stack, transformType, isLeftHanded);
                MinecraftForge.EVENT_BUS.post((Event)new RenderItemEvent.Held.Post(entity, stack, transformType, handSide, partialTicks));
            }
            GlStateManager.popMatrix();
        }
    }

    private boolean isArmVisible(HandSide handSide) {
        PlayerModel model = (PlayerModel)this.func_215332_c();
        switch (handSide) {
            case LEFT: {
                return !model.field_178724_i.field_78807_k && model.field_178724_i.field_78806_j;
            }
            case RIGHT: {
                return !model.field_178723_h.field_78807_k && model.field_178723_h.field_78806_j;
            }
        }
        return false;
    }

    private void translateToHand(HandSide handSide) {
        ((PlayerModel)this.func_215332_c()).func_187073_a(0.0625f, handSide);
    }

    public boolean func_177142_b() {
        return false;
    }
}

