/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.crop.ICropGetter;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class FertilizedEssenceItem
extends BaseItem {
    public FertilizedEssenceItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        Direction direction = context.func_196000_l();
        if (player == null || !player.func_175151_a(pos.func_177972_a(direction), direction, stack)) {
            return ActionResultType.FAIL;
        }
        if (FertilizedEssenceItem.applyFertilizer(stack, world, pos, player)) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, pos, 0);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int chance = (int)((Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get() * 100.0);
        tooltip.add(ModTooltips.FERTILIZED_ESSENCE_CHANCE.args(new Object[]{chance + "%"}).build());
    }

    public static boolean applyFertilizer(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        IGrowable growable;
        BlockState state = world.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)world, (BlockPos)pos, (BlockState)state, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        Block block = state.func_177230_c();
        if (block instanceof IGrowable && (growable = (IGrowable)block).func_176473_a((IBlockReader)world, pos, state, world.func_201670_d())) {
            if (!world.func_201670_d()) {
                Random random = world.func_201674_k();
                if (growable.func_180670_a(world, random, pos, state) || FertilizedEssenceItem.canGrowResourceCrops(growable)) {
                    growable.func_176474_b(world, random, pos, state);
                }
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private static boolean canGrowResourceCrops(IGrowable growable) {
        return growable instanceof ICropGetter && ((ICropGetter)growable).getCrop().getTier().isFertilizable();
    }
}

