/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.blakebr0.mysticalagriculture.tileentity.ReprocessorTileEntity;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReprocessorBlock
extends BaseTileEntityBlock {
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private final ReprocessorTier tier;

    public ReprocessorBlock(ReprocessorTier tier) {
        super(Material.field_151573_f, SoundType.field_185852_e, 3.5f, 3.5f);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
        this.tier = tier;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.tier.getNewTileEntity();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile;
        if (!world.func_201670_d() && (tile = world.func_175625_s(pos)) instanceof ReprocessorTileEntity) {
            player.func_213829_a((INamedContainerProvider)tile);
        }
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ReprocessorTileEntity) {
                ReprocessorTileEntity furnace = (ReprocessorTileEntity)tile;
                InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)furnace.getInventory().getStacks());
            }
            if (state.hasTileEntity()) {
                world.func_175713_t(pos);
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(ModTooltips.REPROCESSOR_SPEED.args(new Object[]{this.tier.getOperationTime()}).build());
        tooltip.add(ModTooltips.REPROCESSOR_FUEL_RATE.args(new Object[]{this.tier.getFuelUsage()}).build());
        tooltip.add(ModTooltips.REPROCESSOR_FUEL_CAPACITY.args(new Object[]{this.tier.getFuelCapacity()}).build());
    }

    public static enum ReprocessorTier {
        BASIC("basic", 200, 1, 1600, ReprocessorTileEntity.Basic::new),
        INFERIUM("inferium", 100, 2, 6400, ReprocessorTileEntity.Inferium::new),
        PRUDENTIUM("prudentium", 80, 2, 9600, ReprocessorTileEntity.Prudentium::new),
        TERTIUM("tertium", 54, 3, 14400, ReprocessorTileEntity.Tertium::new),
        IMPERIUM("imperium", 20, 7, 20800, ReprocessorTileEntity.Imperium::new),
        SUPREMIUM("supremium", 5, 26, 28000, ReprocessorTileEntity.Supremium::new);

        private String name;
        private int operationTime;
        private int fuelUsage;
        private int fuelCapacity;
        private Supplier<ReprocessorTileEntity> tileEntitySupplier;

        private ReprocessorTier(String name, int operationTime, int fuelUsage, int fuelCapacity, Supplier<ReprocessorTileEntity> tileEntitySupplier) {
            this.name = name;
            this.operationTime = operationTime;
            this.fuelUsage = fuelUsage;
            this.fuelCapacity = fuelCapacity;
            this.tileEntitySupplier = tileEntitySupplier;
        }

        public String getName() {
            return this.name;
        }

        public int getOperationTime() {
            return this.operationTime;
        }

        public int getFuelUsage() {
            return this.fuelUsage;
        }

        public int getFuelCapacity() {
            return this.fuelCapacity;
        }

        public ReprocessorTileEntity getNewTileEntity() {
            return this.tileEntitySupplier.get();
        }
    }
}

