/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.soul.IMobSoulType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MobSoulUtils {
    private static final RegistryObject<Item> SOUL_JAR = RegistryObject.of((ResourceLocation)new ResourceLocation("mysticalagriculture", "soul_jar"), (IForgeRegistry)ForgeRegistries.ITEMS);

    public static CompoundNBT makeTag(IMobSoulType type) {
        return MobSoulUtils.makeTag(type, type.getSoulRequirement());
    }

    public static CompoundNBT makeTag(IMobSoulType type, double souls) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Type", type.getId().toString());
        nbt.func_74780_a("Souls", Math.min(souls, type.getSoulRequirement()));
        return nbt;
    }

    public static ItemStack getSoulJar(IMobSoulType type, double souls) {
        CompoundNBT nbt = MobSoulUtils.makeTag(type, souls);
        ItemStack stack = new ItemStack((IItemProvider)SOUL_JAR.get());
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack getFilledSoulJar(IMobSoulType type) {
        CompoundNBT nbt = MobSoulUtils.makeTag(type);
        ItemStack stack = new ItemStack((IItemProvider)SOUL_JAR.get());
        stack.func_77982_d(nbt);
        return stack;
    }

    public static IMobSoulType getType(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Type")) {
            String type = nbt.func_74779_i("Type");
            return MysticalAgricultureAPI.getMobSoulTypeRegistry().getMobSoulTypeById(new ResourceLocation(type));
        }
        return null;
    }

    public static double getSouls(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Souls")) {
            return nbt.func_74769_h("Souls");
        }
        return 0.0;
    }

    public static double addSoulsToJar(ItemStack stack, IMobSoulType type, double amount) {
        IMobSoulType containedType = MobSoulUtils.getType(stack);
        if (containedType != null && containedType != type) {
            return amount;
        }
        double requirement = type.getSoulRequirement();
        if (containedType == null) {
            CompoundNBT nbt = MobSoulUtils.makeTag(type, amount);
            stack.func_77982_d(nbt);
            return Math.max(0.0, requirement - amount);
        }
        double souls = MobSoulUtils.getSouls(stack);
        if (souls >= requirement) {
            return amount;
        }
        double newSouls = Math.min(requirement, souls + amount);
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_74780_a("Souls", newSouls);
            return Math.max(0.0, amount - (newSouls - souls));
        }
        return amount;
    }
}

