/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class AugmentUtils {
    public static void addAugment(ItemStack stack, IAugment augment, int slot) {
        ITinkerable tinkerable;
        Item item = stack.func_77973_b();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && tinkerable.getTinkerableTier() >= augment.getTier()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
                stack.func_77982_d(nbt);
            }
            nbt.func_74778_a("Augment-" + slot, augment.getId().toString());
        }
    }

    public static void removeAugment(ItemStack stack, int slot) {
        ITinkerable tinkerable;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && nbt.func_74764_b("Augment-" + slot)) {
            nbt.func_82580_o("Augment-" + slot);
        }
    }

    public static IAugment getAugment(ItemStack stack, int slot) {
        ITinkerable tinkerable;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && nbt.func_74764_b("Augment-" + slot)) {
            String name = nbt.func_74779_i("Augment-" + slot);
            return MysticalAgricultureAPI.getAugmentRegistry().getAugmentById(new ResourceLocation(name));
        }
        return null;
    }

    public static List<IAugment> getAugments(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        ArrayList<IAugment> augments = new ArrayList<IAugment>();
        if (nbt == null) {
            return augments;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)item;
            int slots = tinkerable.getAugmentSlots();
            for (int i = 0; i < slots; ++i) {
                IAugment augment = AugmentUtils.getAugment(stack, i);
                if (augment == null) continue;
                augments.add(augment);
            }
        }
        return augments;
    }

    public static List<IAugment> getArmorAugments(PlayerEntity player) {
        NonNullList armor = player.field_71071_by.field_70460_b;
        ArrayList<IAugment> augments = new ArrayList<IAugment>();
        for (ItemStack stack : armor) {
            augments.addAll(AugmentUtils.getAugments(stack));
        }
        return augments;
    }

    public static TextFormatting getColorForTier(int tier) {
        switch (tier) {
            case 1: {
                return CropTier.ONE.getTextColor();
            }
            case 2: {
                return CropTier.TWO.getTextColor();
            }
            case 3: {
                return CropTier.THREE.getTextColor();
            }
            case 4: {
                return CropTier.FOUR.getTextColor();
            }
            case 5: {
                return CropTier.FIVE.getTextColor();
            }
        }
        return TextFormatting.GRAY;
    }

    public static ITextComponent getTooltipForTier(int tier) {
        return new StringTextComponent(String.valueOf(tier)).func_211708_a(AugmentUtils.getColorForTier(tier));
    }
}

