/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.lib;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.registries.ForgeRegistries;

public class LazyIngredient {
    public static final LazyIngredient EMPTY = new LazyIngredient(null, null, null){

        @Override
        public Ingredient getIngredient() {
            return Ingredient.field_193370_a;
        }
    };
    private String name;
    private CompoundNBT nbt;
    private Type type;
    private Ingredient ingredient;

    private LazyIngredient(String name, Type type, CompoundNBT nbt) {
        this.name = name;
        this.type = type;
        this.nbt = nbt;
    }

    public static LazyIngredient item(String name) {
        return LazyIngredient.item(name, null);
    }

    public static LazyIngredient item(String name, CompoundNBT nbt) {
        return new LazyIngredient(name, Type.ITEM, nbt);
    }

    public static LazyIngredient tag(String name) {
        return new LazyIngredient(name, Type.TAG, null);
    }

    public boolean isItem() {
        return this.type == Type.ITEM;
    }

    public boolean isTag() {
        return this.type == Type.TAG;
    }

    public Ingredient getIngredient() {
        if (this.ingredient == null) {
            Item item;
            this.ingredient = Ingredient.field_193370_a;
            if (this.isTag()) {
                Tag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(this.name));
                if (tag != null && !tag.func_199885_a().isEmpty()) {
                    this.ingredient = Ingredient.func_199805_a((Tag)tag);
                }
            } else if (this.isItem() && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.name))) != null) {
                if (this.nbt == null || this.nbt.isEmpty()) {
                    this.ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
                } else {
                    ItemStack stack = new ItemStack((IItemProvider)item);
                    stack.func_77982_d(this.nbt);
                    this.ingredient = new NBTIngredient(stack);
                }
            }
        }
        return this.ingredient;
    }

    private static class NBTIngredient
    extends IngredientNBT {
        private NBTIngredient(ItemStack stack) {
            super(stack);
        }
    }

    private static enum Type {
        ITEM,
        TAG;

    }
}

