/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import net.minecraft.block.BlockState;
import net.minecraft.block.FourWayBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import xiroc.dungeoncrawl.util.IRandom;

public class RotationHelper {
    private static final Direction[] FACINGS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP};
    public static final IRandom<Direction> RANDOM_FACING = rand -> FACINGS[rand.nextInt(FACINGS.length)];
    public static final IRandom<Direction> RANDOM_FACING_FLAT = rand -> FACINGS[rand.nextInt(4)];
    public static final Direction[] EAST_SOUTH_WEST = new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] EAST_NORTH_WEST = new Direction[]{Direction.EAST, Direction.NORTH, Direction.WEST};
    public static final Direction[] NORTH_SOUTH_EAST = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST};
    public static final Direction[] NORTH_SOUTH_WEST = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST};

    public static BlockState tanslateFourWayBlock(BlockState state, Rotation rotation) {
        boolean north = (Boolean)state.func_177229_b((IProperty)FourWayBlock.field_196409_a);
        boolean east = (Boolean)state.func_177229_b((IProperty)FourWayBlock.field_196411_b);
        boolean south = (Boolean)state.func_177229_b((IProperty)FourWayBlock.field_196413_c);
        boolean west = (Boolean)state.func_177229_b((IProperty)FourWayBlock.field_196414_y);
        boolean waterlogged = (Boolean)state.func_177229_b((IProperty)FourWayBlock.field_204514_u);
        switch (rotation) {
            case NONE: {
                return state;
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)FourWayBlock.field_204514_u, (Comparable)Boolean.valueOf(waterlogged));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)FourWayBlock.field_204514_u, (Comparable)Boolean.valueOf(waterlogged));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)FourWayBlock.field_204514_u, (Comparable)Boolean.valueOf(waterlogged));
            }
        }
        return state;
    }

    public static Direction translateDirection(Direction direction, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return RotationHelper.translateDirectionInverse(direction);
            }
            case CLOCKWISE_90: {
                return RotationHelper.translateDirectionRight(direction);
            }
            case COUNTERCLOCKWISE_90: {
                return RotationHelper.translateDirectionLeft(direction);
            }
            case NONE: {
                return direction;
            }
        }
        return direction;
    }

    public static Direction translateDirectionRight(Direction direction) {
        switch (direction) {
            case DOWN: {
                return Direction.DOWN;
            }
            case UP: {
                return Direction.UP;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case NORTH: {
                return Direction.EAST;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return null;
    }

    public static Direction translateDirectionLeft(Direction direction) {
        switch (direction) {
            case DOWN: {
                return Direction.DOWN;
            }
            case UP: {
                return Direction.UP;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return null;
    }

    public static Direction translateDirectionInverse(Direction direction) {
        switch (direction) {
            case DOWN: {
                return Direction.DOWN;
            }
            case UP: {
                return Direction.UP;
            }
            case EAST: {
                return Direction.WEST;
            }
            case NORTH: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.NORTH;
            }
            case WEST: {
                return Direction.EAST;
            }
        }
        return null;
    }

    public static Rotation getRotationFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.CLOCKWISE_90;
            }
            case EAST: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case WEST: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getOppositeRotationFromFacing(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_180;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromCW90DoubleFacing(Direction dir1, Direction dir2) {
        switch (dir1) {
            case WEST: {
                switch (dir2) {
                    case SOUTH: {
                        return Rotation.NONE;
                    }
                    case NORTH: {
                        return Rotation.CLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
            case NORTH: {
                switch (dir2) {
                    case WEST: {
                        return Rotation.CLOCKWISE_90;
                    }
                    case EAST: {
                        return Rotation.CLOCKWISE_180;
                    }
                }
                return Rotation.NONE;
            }
            case EAST: {
                switch (dir2) {
                    case NORTH: {
                        return Rotation.CLOCKWISE_180;
                    }
                    case SOUTH: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
            case SOUTH: {
                switch (dir2) {
                    case WEST: {
                        return Rotation.NONE;
                    }
                    case EAST: {
                        return Rotation.COUNTERCLOCKWISE_90;
                    }
                }
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromTripleFacing(Direction dir1, Direction dir2, Direction dir3) {
        if (RotationHelper.containsAllThree(dir1, dir2, dir3, EAST_SOUTH_WEST)) {
            return Rotation.NONE;
        }
        if (RotationHelper.containsAllThree(dir1, dir2, dir3, EAST_NORTH_WEST)) {
            return Rotation.CLOCKWISE_180;
        }
        if (RotationHelper.containsAllThree(dir1, dir2, dir3, NORTH_SOUTH_EAST)) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (RotationHelper.containsAllThree(dir1, dir2, dir3, NORTH_SOUTH_WEST)) {
            return Rotation.CLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public static Rotation getRotationFromInt(int rotation) {
        switch (rotation) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int getIntFromRotation(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return 2;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
            case NONE: {
                return 0;
            }
        }
        return 0;
    }

    public static boolean containsAllThree(Direction dir1, Direction dir2, Direction dir3, Direction[] directions) {
        boolean d1 = false;
        boolean d2 = false;
        boolean d3 = false;
        for (Direction d : directions) {
            if (d == dir1) {
                d1 = true;
                continue;
            }
            if (d == dir2) {
                d2 = true;
                continue;
            }
            if (d != dir3) continue;
            d3 = true;
        }
        return d1 && d2 && d3;
    }
}

