/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.module;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.module.ModuleManager;
import xiroc.dungeoncrawl.part.block.BlockRegistry;
import xiroc.dungeoncrawl.part.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.theme.Theme;

public class BOPCompatModule
extends ModuleManager.Module {
    public static final Logger LOGGER = LogManager.getLogger((String)"Dungeon Crawl/BOP Compat");

    public BOPCompatModule() {
        super(DungeonCrawl.locate("biomesoplenty_compat"), "biomesoplenty");
    }

    @Override
    public boolean load() {
        WeightedRandomBlock mudFloor = new WeightedRandomBlock(new BlockRegistry.TupleIntBlock[]{new BlockRegistry.TupleIntBlock(2, BOPBlocks.mud.func_176223_P()), new BlockRegistry.TupleIntBlock(1, BOPBlocks.mud_bricks.func_176223_P()), new BlockRegistry.TupleIntBlock(1, Blocks.field_196660_k.func_176223_P())});
        BOPCompatModule.addStructureToBiome(BOPBiomes.alps);
        BOPCompatModule.addStructureToBiome(BOPBiomes.alps_foothills);
        BOPCompatModule.addStructureToBiome(BOPBiomes.bayou);
        BOPCompatModule.addStructureToBiome(BOPBiomes.bog);
        BOPCompatModule.addStructureToBiome(BOPBiomes.boreal_forest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.brushland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.chaparral);
        BOPCompatModule.addStructureToBiome(BOPBiomes.cherry_blossom_grove);
        BOPCompatModule.addStructureToBiome(BOPBiomes.cold_desert);
        BOPCompatModule.addStructureToBiome(BOPBiomes.coniferous_forest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.dead_forest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.fir_clearing);
        BOPCompatModule.addStructureToBiome(BOPBiomes.floodplain);
        BOPCompatModule.addStructureToBiome(BOPBiomes.flower_meadow);
        BOPCompatModule.addStructureToBiome(BOPBiomes.grassland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.gravel_beach);
        BOPCompatModule.addStructureToBiome(BOPBiomes.grove);
        BOPCompatModule.addStructureToBiome(BOPBiomes.highland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.highland_moor);
        BOPCompatModule.addStructureToBiome(BOPBiomes.lavender_field);
        BOPCompatModule.addStructureToBiome(BOPBiomes.lush_grassland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.lush_swamp);
        BOPCompatModule.addStructureToBiome(BOPBiomes.maple_woods);
        BOPCompatModule.addStructureToBiome(BOPBiomes.meadow);
        BOPCompatModule.addStructureToBiome(BOPBiomes.mire);
        BOPCompatModule.addStructureToBiome(BOPBiomes.mystic_grove);
        BOPCompatModule.addStructureToBiome(BOPBiomes.oasis);
        BOPCompatModule.addStructureToBiome(BOPBiomes.ominous_woods);
        BOPCompatModule.addStructureToBiome(BOPBiomes.orchard);
        BOPCompatModule.addStructureToBiome(BOPBiomes.origin_beach);
        BOPCompatModule.addStructureToBiome(BOPBiomes.origin_hills);
        BOPCompatModule.addStructureToBiome(BOPBiomes.outback);
        BOPCompatModule.addStructureToBiome(BOPBiomes.overgrown_cliffs);
        BOPCompatModule.addStructureToBiome(BOPBiomes.pasture);
        BOPCompatModule.addStructureToBiome(BOPBiomes.prairie);
        BOPCompatModule.addStructureToBiome(BOPBiomes.pumpkin_patch);
        BOPCompatModule.addStructureToBiome(BOPBiomes.rainforest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.scrubland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.seasonal_forest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.shield);
        BOPCompatModule.addStructureToBiome(BOPBiomes.shrubland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.silkglade);
        BOPCompatModule.addStructureToBiome(BOPBiomes.snowy_coniferous_forest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.snowy_fir_clearing);
        BOPCompatModule.addStructureToBiome(BOPBiomes.snowy_forest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.steppe);
        BOPCompatModule.addStructureToBiome(BOPBiomes.temperate_rainforest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.temperate_rainforest_hills);
        BOPCompatModule.addStructureToBiome(BOPBiomes.tropical_rainforest);
        BOPCompatModule.addStructureToBiome(BOPBiomes.tropics);
        BOPCompatModule.addStructureToBiome(BOPBiomes.tundra);
        BOPCompatModule.addStructureToBiome(BOPBiomes.wasteland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.wetland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.woodland);
        BOPCompatModule.addStructureToBiome(BOPBiomes.xeric_shrubland);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:xeric_shrubland", 3);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:grove", 5);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:land_of_lakes", 5);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:maple_woods", 5);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:shield", 5);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:bayou", 32);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:wetland", 32);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:lavender_field", 33);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:brushland", 34);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:dead_forest", 34);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:dead_swamp", 34);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:wasteland", 34);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:cherry_blossom_grove", 35);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:coniferous_forest", 36);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:snowy_coniferous_forest", 36);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:omnious_woods", 37);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:overgrown_cliffs", 38);
        Theme.BIOME_TO_SUBTHEME_MAP.put("biomesoplenty:tropical_rainforest", 38);
        Theme.ID_TO_SUBTHEME_MAP.put(32, new Theme.SubTheme(BOPBlocks.willow_log.func_176223_P(), BOPBlocks.willow_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.willow_door.func_176223_P(), BOPBlocks.willow_planks.func_176223_P()));
        Theme.ID_TO_SUBTHEME_MAP.put(33, new Theme.SubTheme(BOPBlocks.jacaranda_log.func_176223_P(), BOPBlocks.jacaranda_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.jacaranda_door.func_176223_P(), BOPBlocks.jacaranda_planks.func_176223_P()));
        Theme.ID_TO_SUBTHEME_MAP.put(34, new Theme.SubTheme(BOPBlocks.dead_log.func_176223_P(), BOPBlocks.dead_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.dead_door.func_176223_P(), BOPBlocks.dead_planks.func_176223_P()));
        Theme.ID_TO_SUBTHEME_MAP.put(35, new Theme.SubTheme(BOPBlocks.cherry_log.func_176223_P(), BOPBlocks.cherry_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.cherry_door.func_176223_P(), BOPBlocks.cherry_planks.func_176223_P()));
        Theme.ID_TO_SUBTHEME_MAP.put(36, new Theme.SubTheme(BOPBlocks.fir_log.func_176223_P(), BOPBlocks.fir_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.fir_door.func_176223_P(), BOPBlocks.fir_planks.func_176223_P()));
        Theme.ID_TO_SUBTHEME_MAP.put(37, new Theme.SubTheme(BOPBlocks.umbran_log.func_176223_P(), BOPBlocks.umbran_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.umbran_door.func_176223_P(), BOPBlocks.umbran_planks.func_176223_P()));
        Theme.ID_TO_SUBTHEME_MAP.put(38, new Theme.SubTheme(BOPBlocks.mahogany_log.func_176223_P(), BOPBlocks.mahogany_trapdoor.func_176223_P(), Blocks.field_196677_cy.func_176223_P(), BOPBlocks.mahogany_door.func_176223_P(), BOPBlocks.mahogany_planks.func_176223_P()));
        Theme.BIOME_TO_THEME_MAP.put("biomesoplenty:xeric_shrubland", 16);
        Theme.BIOME_TO_THEME_MAP.put("biomesoplenty:brushland", 64);
        Theme.BIOME_TO_THEME_MAP.put("biomesoplenty:quagmire", 64);
        Theme.ID_TO_THEME_MAP.put(64, new Theme(() -> BOPBlocks.mud_bricks.func_176223_P(), () -> BOPBlocks.mud_bricks.func_176223_P(), mudFloor, () -> BOPBlocks.mud_brick_stairs.func_176223_P(), () -> BOPBlocks.mud.func_176223_P(), () -> BOPBlocks.mud_brick_wall.func_176223_P(), mudFloor));
        Theme.RANDOMIZERS.put(64, Theme.createRandomizer(64, 0, 49));
        return true;
    }

    private static void addStructureToBiome(Optional<Biome> biome) {
        if (biome.isPresent()) {
            biome.get().func_201865_a((Structure)Dungeon.DUNGEON, (IFeatureConfig)NoFeatureConfig.field_202429_e);
            LOGGER.info("Added Generation to BOP Biome {}", (Object)biome.get().getRegistryName().toString());
        } else {
            LOGGER.error("Failed to add a BOP biome: Biome was not present. ({})", biome);
        }
    }
}

