/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.segment;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.eventbus.api.Event;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.api.event.DungeonSegmentModelLoadEvent;
import xiroc.dungeoncrawl.dungeon.segment.DungeonSegmentModel;
import xiroc.dungeoncrawl.util.ModelHelper;

public class DungeonSegmentModelRegistry {
    public static boolean LOADED = false;
    public static final HashMap<Integer, DungeonSegmentModel> MAP = new HashMap();
    public static DungeonSegmentModel BRIDGE;
    public static DungeonSegmentModel BRIDGE_TURN;
    public static DungeonSegmentModel BRIDGE_SIDE;
    public static DungeonSegmentModel BRIDGE_ALL_SIDES;
    public static DungeonSegmentModel CORRIDOR;
    public static DungeonSegmentModel CORRIDOR_TURN;
    public static DungeonSegmentModel CORRIDOR_OPEN;
    public static DungeonSegmentModel CORRIDOR_ALL_OPEN;
    public static DungeonSegmentModel CORRIDOR_2;
    public static DungeonSegmentModel CORRIDOR_2_TURN;
    public static DungeonSegmentModel CORRIDOR_2_OPEN;
    public static DungeonSegmentModel CORRIDOR_2_ALL_OPEN;
    public static DungeonSegmentModel CORRIDOR_3;
    public static DungeonSegmentModel CORRIDOR_3_TURN;
    public static DungeonSegmentModel CORRIDOR_3_OPEN;
    public static DungeonSegmentModel CORRIDOR_3_ALL_OPEN;
    public static DungeonSegmentModel CORRIDOR_ROOM;
    public static DungeonSegmentModel CORRIDOR_TRAP;
    public static DungeonSegmentModel CORRIDOR_FIRE;
    public static DungeonSegmentModel CORRIDOR_GRASS;
    public static DungeonSegmentModel HOLE;
    public static DungeonSegmentModel HOLE_LAVA;
    public static DungeonSegmentModel HOLE_TRAP;
    public static DungeonSegmentModel SIDE_ROOM_SMALL_LIBRARY;
    public static DungeonSegmentModel SIDE_ROOM_FARM;
    public static DungeonSegmentModel SIDE_ROOM_TNT;
    public static DungeonSegmentModel STAIRS;
    public static DungeonSegmentModel STAIRS_TOP;
    public static DungeonSegmentModel STAIRS_BOTTOM;
    public static DungeonSegmentModel ROOM;
    public static DungeonSegmentModel LARGE_ROOM;
    public static DungeonSegmentModel LIBRARY;
    public static DungeonSegmentModel LOOT_ROOM;
    public static DungeonSegmentModel BOSS_ROOM;
    public static DungeonSegmentModel ENTRANCE_TOWER_0;
    public static DungeonSegmentModel ENTRANCE_TOWER_1;
    public static DungeonSegmentModel KITCHEN;
    public static DungeonSegmentModel STARTER_ROOM;

    public static synchronized void load() {
        if (LOADED) {
            return;
        }
        LOADED = true;
        DungeonCrawl.LOGGER.info("Loading models");
        CORRIDOR = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor.nbt").build().setId(0);
        CORRIDOR_TURN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_turn.nbt").build().setId(1);
        CORRIDOR_OPEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_open.nbt").build().setId(2);
        CORRIDOR_ALL_OPEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_all_open.nbt").build().setId(3);
        CORRIDOR_2 = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_2.nbt").build().setId(4);
        CORRIDOR_2_TURN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_2_turn.nbt").build().setId(5);
        CORRIDOR_2_OPEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_2_open.nbt").build().setId(6);
        CORRIDOR_2_ALL_OPEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_2_all_open.nbt").build().setId(7);
        CORRIDOR_3 = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_3.nbt").build().setId(8);
        CORRIDOR_3_TURN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_3_turn.nbt").build().setId(9);
        CORRIDOR_3_OPEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_3_open.nbt").build().setId(10);
        CORRIDOR_3_ALL_OPEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_3_all_open.nbt").build().setId(11);
        CORRIDOR_ROOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_room.nbt").build().setId(12);
        CORRIDOR_TRAP = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_trap.nbt").build().setId(13);
        HOLE = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/hole.nbt").build().setId(14);
        HOLE_LAVA = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/hole_lava.nbt").build().setId(15);
        STAIRS = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/stairs.nbt").build().setId(16);
        STAIRS_TOP = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/stairs_top.nbt").build().setId(17);
        STAIRS_BOTTOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/stairs_bottom.nbt").build().setId(18);
        ROOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/room.nbt").build().setId(19);
        ENTRANCE_TOWER_0 = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/entrance_tower_0.nbt").build().setId(20);
        BRIDGE = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/bridge.nbt").build().setId(21);
        BRIDGE_TURN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/bridge_turn.nbt").build().setId(22);
        BRIDGE_SIDE = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/bridge_side.nbt").build().setId(23);
        BRIDGE_ALL_SIDES = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/bridge_all_sides.nbt").build().setId(24);
        LARGE_ROOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/large_room.nbt").build().setId(25);
        KITCHEN = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/kitchen.nbt").build().setId(27);
        LOOT_ROOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/loot_room.nbt").build().setId(28);
        CORRIDOR_FIRE = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_fire.nbt").build().setId(29);
        SIDE_ROOM_SMALL_LIBRARY = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/side_room_small_library.nbt").build().setId(30);
        SIDE_ROOM_FARM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/side_room_farm.nbt").build().setId(31);
        CORRIDOR_GRASS = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/corridor_grass.nbt").build().setId(32);
        ENTRANCE_TOWER_1 = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/entrance_tower_1.nbt").build().setId(32);
        SIDE_ROOM_TNT = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/side_room_tnt.nbt").build().setId(33);
        STARTER_ROOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/starter_room.nbt").build().setId(34);
        LIBRARY = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/library.nbt").build().setId(35);
        BOSS_ROOM = DungeonSegmentModelRegistry.loadFromFile("models/dungeon/boss_room.nbt").build().setId(36);
    }

    public static DungeonSegmentModel loadFromFile(String path) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)path);
        try {
            DataInputStream input = new DataInputStream(DungeonSegmentModelRegistry.class.getResourceAsStream("/data/dungeoncrawl/" + path));
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_152446_a((DataInput)input, 16, NBTSizeTracker.field_152451_a);
            return ModelHelper.getModelFromNBT(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static DungeonSegmentModel loadFromFile(String path, IResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)path);
        DungeonSegmentModelLoadEvent loadEvent = new DungeonSegmentModelLoadEvent(path);
        if (DungeonCrawl.EVENT_BUS.post((Event)loadEvent)) {
            return null;
        }
        try {
            DataInputStream input = new DataInputStream(resourceManager.func_199002_a(DungeonCrawl.locate(loadEvent.path)).func_199027_b());
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_152446_a((DataInput)input, 16, NBTSizeTracker.field_152451_a);
            return ModelHelper.getModelFromNBT(nbt);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

